/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.api.xml;

import org.mule.runtime.ast.api.AstParserAttribute;
import org.mule.runtime.dsl.api.xml.parser.XmlApplicationParser;

/**
 * XML-specific parsing attributes.
 *
 * @since 1.1
 */
public class AstXmlParserAttribute<T> extends AstParserAttribute<T> {

  // we need to make sure the key for IS_CDATA is the same as the one defined in the XmlApplicationParser from dsl-api
  // for backwards compatibility
  public static final AstXmlParserAttribute<Boolean> IS_CDATA =
      new AstXmlParserAttribute<>(XmlApplicationParser.IS_CDATA);
  public static final AstXmlParserAttribute<Integer> OPENING_TAG_START_LINE =
      new AstXmlParserAttribute<>("OPENING_TAG_START_LINE");
  public static final AstXmlParserAttribute<Integer> OPENING_TAG_START_COLUMN =
      new AstXmlParserAttribute<>("OPENING_TAG_START_COLUMN");
  public static final AstXmlParserAttribute<Integer> OPENING_TAG_END_LINE =
      new AstXmlParserAttribute<>("OPENING_TAG_END_LINE");
  public static final AstXmlParserAttribute<Integer> OPENING_TAG_END_COLUMN =
      new AstXmlParserAttribute<>("OPENING_TAG_END_COLUMN");
  public static final AstXmlParserAttribute<Integer> CLOSING_TAG_START_LINE =
      new AstXmlParserAttribute<>("CLOSING_TAG_START_LINE");
  public static final AstXmlParserAttribute<Integer> CLOSING_TAG_START_COLUMN =
      new AstXmlParserAttribute<>("CLOSING_TAG_START_COLUMN");
  public static final AstXmlParserAttribute<Integer> CLOSING_TAG_END_LINE =
      new AstXmlParserAttribute<>("CLOSING_TAG_END_LINE");
  public static final AstXmlParserAttribute<Integer> CLOSING_TAG_END_COLUMN =
      new AstXmlParserAttribute<>("CLOSING_TAG_END_COLUMN");
  public static final AstXmlParserAttribute<Boolean> IS_SELF_CLOSING =
      new AstXmlParserAttribute<>("IS_SELF_CLOSING");

  private AstXmlParserAttribute(String key) {
    super(key);
  }
}
