/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.test.internal.xml.metadata;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.ast.api.xml.AstXmlParserAttribute;
import org.mule.runtime.ast.test.internal.xml.DefaultAstXmlParserTestCase;
import org.mule.runtime.dsl.api.ConfigResource;

@Feature(value="Mule Artifact AST")
@Story(value="Source Location")
public class LocationMetadataTestCase {
    private ClassLoader classLoader;
    private AstXmlParser parser;

    @Before
    public void before() {
        this.classLoader = DefaultAstXmlParserTestCase.class.getClassLoader();
        this.parser = AstXmlParser.builder().withSchemaValidationsDisabled().withPropertyResolver(propertyKey -> propertyKey).build();
    }

    @Test
    @Issue(value="MULE-19634")
    public void propertyLocationMetadata() throws URISyntaxException {
        String resourceName = "metadata/flow-with-source-and-operations.xml";
        URL resource = this.getClass().getResource("/metadata/flow-with-source-and-operations.xml");
        ArtifactAst simpleAst = this.parser.parse(new URL[]{resource});
        ComponentAst globalProperty = (ComponentAst)simpleAst.topLevelComponents().get(0);
        ComponentMetadataAst metadata = globalProperty.getMetadata();
        MatcherAssert.assertThat((Object)((String)metadata.getFileName().get()), (Matcher)Is.is((Object)"metadata/flow-with-source-and-operations.xml"));
        MatcherAssert.assertThat((Object)((URI)metadata.getFileUri().get()), (Matcher)Is.is((Object)resource.toURI()));
        MatcherAssert.assertThat((Object)metadata.getStartLine().getAsInt(), (Matcher)Is.is((Object)11));
        MatcherAssert.assertThat((Object)metadata.getStartLine().getAsInt(), (Matcher)Is.is((Object)11));
        MatcherAssert.assertThat((Object)metadata.getStartColumn().getAsInt(), (Matcher)Is.is((Object)5));
        MatcherAssert.assertThat((Object)metadata.getEndLine().getAsInt(), (Matcher)Is.is((Object)11));
        MatcherAssert.assertThat((Object)metadata.getEndColumn().getAsInt(), (Matcher)Is.is((Object)49));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_START_LINE.get(metadata), (Matcher)Is.is(Optional.of(11)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_START_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(5)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_END_LINE.get(metadata), (Matcher)Is.is(Optional.of(11)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_END_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(49)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_START_LINE.get(metadata), (Matcher)Is.is(Optional.of(11)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_START_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(5)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_END_LINE.get(metadata), (Matcher)Is.is(Optional.of(11)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_END_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(49)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.IS_SELF_CLOSING.get(metadata), (Matcher)Is.is(Optional.of(true)));
    }

    @Test
    public void configLocationMetadata() throws URISyntaxException {
        String resourceName = "metadata/flow-with-source-and-operations.xml";
        URL resource = this.getClass().getResource("/metadata/flow-with-source-and-operations.xml");
        ArtifactAst simpleAst = this.parser.parse(new URL[]{resource});
        ComponentAst httpConfig = (ComponentAst)simpleAst.topLevelComponents().get(1);
        ComponentMetadataAst metadata = httpConfig.getMetadata();
        MatcherAssert.assertThat((Object)((String)metadata.getFileName().get()), (Matcher)Is.is((Object)"metadata/flow-with-source-and-operations.xml"));
        MatcherAssert.assertThat((Object)((URI)metadata.getFileUri().get()), (Matcher)Is.is((Object)resource.toURI()));
        MatcherAssert.assertThat((Object)metadata.getStartLine().getAsInt(), (Matcher)Is.is((Object)12));
        MatcherAssert.assertThat((Object)metadata.getStartColumn().getAsInt(), (Matcher)Is.is((Object)5));
        MatcherAssert.assertThat((Object)metadata.getEndLine().getAsInt(), (Matcher)Is.is((Object)14));
        MatcherAssert.assertThat((Object)metadata.getEndColumn().getAsInt(), (Matcher)Is.is((Object)28));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_START_LINE.get(metadata), (Matcher)Is.is(Optional.of(12)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_START_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(5)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_END_LINE.get(metadata), (Matcher)Is.is(Optional.of(12)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_END_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(46)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_START_LINE.get(metadata), (Matcher)Is.is(Optional.of(14)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_START_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(5)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_END_LINE.get(metadata), (Matcher)Is.is(Optional.of(14)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_END_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(28)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.IS_SELF_CLOSING.get(metadata).orElse(false), (Matcher)Is.is((Object)false));
    }

    @Test
    public void flowLocationMetadata() throws URISyntaxException {
        String resourceName = "metadata/flow-with-source-and-operations.xml";
        URL resource = this.getClass().getResource("/metadata/flow-with-source-and-operations.xml");
        ArtifactAst simpleAst = this.parser.parse(new URL[]{resource});
        ComponentAst flow = (ComponentAst)simpleAst.topLevelComponents().get(2);
        ComponentMetadataAst metadata = flow.getMetadata();
        MatcherAssert.assertThat((Object)((String)metadata.getFileName().get()), (Matcher)Is.is((Object)"metadata/flow-with-source-and-operations.xml"));
        MatcherAssert.assertThat((Object)((URI)metadata.getFileUri().get()), (Matcher)Is.is((Object)resource.toURI()));
        MatcherAssert.assertThat((Object)metadata.getStartLine().getAsInt(), (Matcher)Is.is((Object)16));
        MatcherAssert.assertThat((Object)metadata.getStartColumn().getAsInt(), (Matcher)Is.is((Object)5));
        MatcherAssert.assertThat((Object)metadata.getEndLine().getAsInt(), (Matcher)Is.is((Object)38));
        MatcherAssert.assertThat((Object)metadata.getEndColumn().getAsInt(), (Matcher)Is.is((Object)12));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_START_LINE.get(metadata), (Matcher)Is.is(Optional.of(16)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_START_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(5)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_END_LINE.get(metadata), (Matcher)Is.is(Optional.of(16)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_END_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(29)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_START_LINE.get(metadata), (Matcher)Is.is(Optional.of(38)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_START_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(5)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_END_LINE.get(metadata), (Matcher)Is.is(Optional.of(38)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_END_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(12)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.IS_SELF_CLOSING.get(metadata).orElse(false), (Matcher)Is.is((Object)false));
    }

    @Test
    @Issue(value="MULE-19634")
    public void sourceLocationMetadata() throws URISyntaxException {
        String resourceName = "metadata/flow-with-source-and-operations.xml";
        URL resource = this.getClass().getResource("/metadata/flow-with-source-and-operations.xml");
        ArtifactAst simpleAst = this.parser.parse(new URL[]{resource});
        ComponentAst flow = (ComponentAst)simpleAst.topLevelComponents().get(2);
        ComponentAst source = (ComponentAst)flow.directChildren().get(0);
        ComponentMetadataAst metadata = source.getMetadata();
        MatcherAssert.assertThat((Object)((String)metadata.getFileName().get()), (Matcher)Is.is((Object)"metadata/flow-with-source-and-operations.xml"));
        MatcherAssert.assertThat((Object)((URI)metadata.getFileUri().get()), (Matcher)Is.is((Object)resource.toURI()));
        MatcherAssert.assertThat((Object)metadata.getStartLine().getAsInt(), (Matcher)Is.is((Object)17));
        MatcherAssert.assertThat((Object)metadata.getStartColumn().getAsInt(), (Matcher)Is.is((Object)9));
        MatcherAssert.assertThat((Object)metadata.getEndLine().getAsInt(), (Matcher)Is.is((Object)17));
        MatcherAssert.assertThat((Object)metadata.getEndColumn().getAsInt(), (Matcher)Is.is((Object)63));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_START_LINE.get(metadata), (Matcher)Is.is(Optional.of(17)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_START_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(9)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_END_LINE.get(metadata), (Matcher)Is.is(Optional.of(17)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_END_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(63)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_START_LINE.get(metadata), (Matcher)Is.is(Optional.of(17)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_START_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(9)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_END_LINE.get(metadata), (Matcher)Is.is(Optional.of(17)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_END_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(63)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.IS_SELF_CLOSING.get(metadata), (Matcher)Is.is(Optional.of(true)));
    }

    @Test
    public void operationTransformLocationMetadata() throws URISyntaxException {
        String resourceName = "metadata/flow-with-source-and-operations.xml";
        URL resource = this.getClass().getResource("/metadata/flow-with-source-and-operations.xml");
        ArtifactAst simpleAst = this.parser.parse(new URL[]{resource});
        ComponentAst flow = (ComponentAst)simpleAst.topLevelComponents().get(2);
        ComponentAst transform = (ComponentAst)flow.directChildren().get(1);
        ComponentMetadataAst metadata = transform.getMetadata();
        MatcherAssert.assertThat((Object)((String)metadata.getFileName().get()), (Matcher)Is.is((Object)"metadata/flow-with-source-and-operations.xml"));
        MatcherAssert.assertThat((Object)((URI)metadata.getFileUri().get()), (Matcher)Is.is((Object)resource.toURI()));
        MatcherAssert.assertThat((Object)metadata.getStartLine().getAsInt(), (Matcher)Is.is((Object)18));
        MatcherAssert.assertThat((Object)metadata.getStartColumn().getAsInt(), (Matcher)Is.is((Object)9));
        MatcherAssert.assertThat((Object)metadata.getEndLine().getAsInt(), (Matcher)Is.is((Object)27));
        MatcherAssert.assertThat((Object)metadata.getEndColumn().getAsInt(), (Matcher)Is.is((Object)24));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_START_LINE.get(metadata), (Matcher)Is.is(Optional.of(18)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_START_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(9)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_END_LINE.get(metadata), (Matcher)Is.is(Optional.of(18)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_END_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(48)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_START_LINE.get(metadata), (Matcher)Is.is(Optional.of(27)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_START_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(9)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_END_LINE.get(metadata), (Matcher)Is.is(Optional.of(27)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_END_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(24)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.IS_SELF_CLOSING.get(metadata).orElse(false), (Matcher)Is.is((Object)false));
    }

    @Test
    public void operationLoggerLocationMetadata() throws URISyntaxException {
        String resourceName = "metadata/flow-with-source-and-operations.xml";
        URL resource = this.getClass().getResource("/metadata/flow-with-source-and-operations.xml");
        ArtifactAst simpleAst = this.parser.parse(new URL[]{resource});
        ComponentAst flow = (ComponentAst)simpleAst.topLevelComponents().get(2);
        ComponentAst logger = (ComponentAst)flow.directChildren().get(2);
        ComponentMetadataAst metadata = logger.getMetadata();
        MatcherAssert.assertThat((Object)((String)metadata.getFileName().get()), (Matcher)Is.is((Object)"metadata/flow-with-source-and-operations.xml"));
        MatcherAssert.assertThat((Object)((URI)metadata.getFileUri().get()), (Matcher)Is.is((Object)resource.toURI()));
        MatcherAssert.assertThat((Object)metadata.getStartLine().getAsInt(), (Matcher)Is.is((Object)28));
        MatcherAssert.assertThat((Object)metadata.getStartColumn().getAsInt(), (Matcher)Is.is((Object)9));
        MatcherAssert.assertThat((Object)metadata.getEndLine().getAsInt(), (Matcher)Is.is((Object)28));
        MatcherAssert.assertThat((Object)metadata.getEndColumn().getAsInt(), (Matcher)Is.is((Object)63));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_START_LINE.get(metadata), (Matcher)Is.is(Optional.of(28)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_START_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(9)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_END_LINE.get(metadata), (Matcher)Is.is(Optional.of(28)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_END_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(63)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_START_LINE.get(metadata), (Matcher)Is.is(Optional.of(28)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_START_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(9)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_END_LINE.get(metadata), (Matcher)Is.is(Optional.of(28)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_END_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(63)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.IS_SELF_CLOSING.get(metadata), (Matcher)Is.is(Optional.of(true)));
    }

    @Test
    public void choiceRouterLocationMetadata() throws URISyntaxException {
        String resourceName = "metadata/flow-with-source-and-operations.xml";
        URL resource = this.getClass().getResource("/metadata/flow-with-source-and-operations.xml");
        ArtifactAst simpleAst = this.parser.parse(new URL[]{resource});
        ComponentAst flow = (ComponentAst)simpleAst.topLevelComponents().get(2);
        ComponentAst choice = (ComponentAst)flow.directChildren().get(4);
        ComponentMetadataAst metadata = choice.getMetadata();
        MatcherAssert.assertThat((Object)((String)metadata.getFileName().get()), (Matcher)Is.is((Object)"metadata/flow-with-source-and-operations.xml"));
        MatcherAssert.assertThat((Object)((URI)metadata.getFileUri().get()), (Matcher)Is.is((Object)resource.toURI()));
        MatcherAssert.assertThat((Object)metadata.getStartLine().getAsInt(), (Matcher)Is.is((Object)30));
        MatcherAssert.assertThat((Object)metadata.getStartColumn().getAsInt(), (Matcher)Is.is((Object)9));
        MatcherAssert.assertThat((Object)metadata.getEndLine().getAsInt(), (Matcher)Is.is((Object)37));
        MatcherAssert.assertThat((Object)metadata.getEndColumn().getAsInt(), (Matcher)Is.is((Object)18));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_START_LINE.get(metadata), (Matcher)Is.is(Optional.of(30)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_START_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(9)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_END_LINE.get(metadata), (Matcher)Is.is(Optional.of(30)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_END_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(17)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_START_LINE.get(metadata), (Matcher)Is.is(Optional.of(37)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_START_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(9)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_END_LINE.get(metadata), (Matcher)Is.is(Optional.of(37)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_END_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(18)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.IS_SELF_CLOSING.get(metadata).orElse(false), (Matcher)Is.is((Object)false));
    }

    @Test
    public void operationRouteLocationMetadata() throws URISyntaxException {
        String resourceName = "metadata/flow-with-source-and-operations.xml";
        URL resource = this.getClass().getResource("/metadata/flow-with-source-and-operations.xml");
        ArtifactAst simpleAst = this.parser.parse(new URL[]{resource});
        ComponentAst flow = (ComponentAst)simpleAst.topLevelComponents().get(2);
        ComponentAst choice = (ComponentAst)flow.directChildren().get(4);
        ComponentAst firstRoute = (ComponentAst)choice.directChildren().get(0);
        ComponentMetadataAst metadata = firstRoute.getMetadata();
        MatcherAssert.assertThat((Object)((String)metadata.getFileName().get()), (Matcher)Is.is((Object)"metadata/flow-with-source-and-operations.xml"));
        MatcherAssert.assertThat((Object)((URI)metadata.getFileUri().get()), (Matcher)Is.is((Object)resource.toURI()));
        MatcherAssert.assertThat((Object)metadata.getStartLine().getAsInt(), (Matcher)Is.is((Object)31));
        MatcherAssert.assertThat((Object)metadata.getStartColumn().getAsInt(), (Matcher)Is.is((Object)13));
        MatcherAssert.assertThat((Object)metadata.getEndLine().getAsInt(), (Matcher)Is.is((Object)33));
        MatcherAssert.assertThat((Object)metadata.getEndColumn().getAsInt(), (Matcher)Is.is((Object)20));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_START_LINE.get(metadata), (Matcher)Is.is(Optional.of(31)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_START_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(13)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_END_LINE.get(metadata), (Matcher)Is.is(Optional.of(31)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_END_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(49)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_START_LINE.get(metadata), (Matcher)Is.is(Optional.of(33)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_START_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(13)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_END_LINE.get(metadata), (Matcher)Is.is(Optional.of(33)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_END_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(20)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.IS_SELF_CLOSING.get(metadata).orElse(false), (Matcher)Is.is((Object)false));
    }

    @Test
    public void operationInChoiceRouteLocationMetadata() throws URISyntaxException {
        String resourceName = "metadata/flow-with-source-and-operations.xml";
        URL resource = this.getClass().getResource("/metadata/flow-with-source-and-operations.xml");
        ArtifactAst simpleAst = this.parser.parse(new URL[]{resource});
        ComponentAst flow = (ComponentAst)simpleAst.topLevelComponents().get(2);
        ComponentAst choice = (ComponentAst)flow.directChildren().get(4);
        ComponentAst firstRoute = (ComponentAst)choice.directChildren().get(0);
        ComponentAst componentInChoiceRoute = (ComponentAst)firstRoute.directChildren().get(0);
        ComponentMetadataAst metadata = componentInChoiceRoute.getMetadata();
        MatcherAssert.assertThat((Object)((String)metadata.getFileName().get()), (Matcher)Is.is((Object)"metadata/flow-with-source-and-operations.xml"));
        MatcherAssert.assertThat((Object)((URI)metadata.getFileUri().get()), (Matcher)Is.is((Object)resource.toURI()));
        MatcherAssert.assertThat((Object)metadata.getStartLine().getAsInt(), (Matcher)Is.is((Object)32));
        MatcherAssert.assertThat((Object)metadata.getStartColumn().getAsInt(), (Matcher)Is.is((Object)17));
        MatcherAssert.assertThat((Object)metadata.getEndLine().getAsInt(), (Matcher)Is.is((Object)32));
        MatcherAssert.assertThat((Object)metadata.getEndColumn().getAsInt(), (Matcher)Is.is((Object)71));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_START_LINE.get(metadata), (Matcher)Is.is(Optional.of(32)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_START_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(17)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_END_LINE.get(metadata), (Matcher)Is.is(Optional.of(32)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_END_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(71)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_START_LINE.get(metadata), (Matcher)Is.is(Optional.of(32)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_START_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(17)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_END_LINE.get(metadata), (Matcher)Is.is(Optional.of(32)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_END_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(71)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.IS_SELF_CLOSING.get(metadata), (Matcher)Is.is(Optional.of(true)));
    }

    @Test
    public void fileNameAndUriAreSameWhenLoadedFromConfigResource() {
        String resourceName = "metadata/flow-with-source-and-operations.xml";
        URL resource = this.getClass().getResource("/metadata/flow-with-source-and-operations.xml");
        MatcherAssert.assertThat((Object)resource, (Matcher)Is.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        ConfigResource configResource = new ConfigResource(resource);
        ArtifactAst simpleAstFromUrl = this.parser.parse(new URL[]{resource});
        ArtifactAst simpleAstFromConfigResource = this.parser.parse(new ConfigResource[]{configResource});
        ArrayList<ComponentAst> componentAstsFromUrl = new ArrayList<ComponentAst>();
        componentAstsFromUrl.add((ComponentAst)simpleAstFromUrl.topLevelComponents().get(2));
        componentAstsFromUrl.add((ComponentAst)((ComponentAst)componentAstsFromUrl.get(0)).directChildren().get(4));
        componentAstsFromUrl.add((ComponentAst)((ComponentAst)componentAstsFromUrl.get(1)).directChildren().get(0));
        componentAstsFromUrl.add((ComponentAst)((ComponentAst)componentAstsFromUrl.get(2)).directChildren().get(0));
        ArrayList<ComponentAst> componentAstsFromConfigResource = new ArrayList<ComponentAst>();
        componentAstsFromConfigResource.add((ComponentAst)simpleAstFromConfigResource.topLevelComponents().get(2));
        componentAstsFromConfigResource.add((ComponentAst)((ComponentAst)componentAstsFromConfigResource.get(0)).directChildren().get(4));
        componentAstsFromConfigResource.add((ComponentAst)((ComponentAst)componentAstsFromConfigResource.get(1)).directChildren().get(0));
        componentAstsFromConfigResource.add((ComponentAst)((ComponentAst)componentAstsFromConfigResource.get(2)).directChildren().get(0));
        for (int i = 0; i < componentAstsFromUrl.size(); ++i) {
            ComponentMetadataAst metadataFromUrl = ((ComponentAst)componentAstsFromUrl.get(i)).getMetadata();
            ComponentMetadataAst metadataFromConfigResource = ((ComponentAst)componentAstsFromConfigResource.get(i)).getMetadata();
            MatcherAssert.assertThat((Object)metadataFromConfigResource.getFileName(), (Matcher)Is.is((Matcher)Matchers.equalTo((Object)metadataFromUrl.getFileName())));
            MatcherAssert.assertThat((Object)metadataFromConfigResource.getFileUri(), (Matcher)Is.is((Matcher)Matchers.equalTo((Object)metadataFromUrl.getFileUri())));
        }
    }

    @Test
    public void locationMetadataIsCorrectWhenOpeningTagsAreMultiline() throws URISyntaxException {
        String resourceName = "metadata/multiline-opening-tags.xml";
        URL resource = this.getClass().getResource("/metadata/multiline-opening-tags.xml");
        ArtifactAst simpleAst = this.parser.parse(new URL[]{resource});
        ComponentAst httpConfig = (ComponentAst)simpleAst.topLevelComponents().get(1);
        ComponentMetadataAst metadata = httpConfig.getMetadata();
        MatcherAssert.assertThat((Object)metadata.getStartLine().getAsInt(), (Matcher)Is.is((Object)10));
        MatcherAssert.assertThat((Object)metadata.getStartColumn().getAsInt(), (Matcher)Is.is((Object)5));
        MatcherAssert.assertThat((Object)metadata.getEndLine().getAsInt(), (Matcher)Is.is((Object)13));
        MatcherAssert.assertThat((Object)metadata.getEndColumn().getAsInt(), (Matcher)Is.is((Object)28));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_START_LINE.get(metadata), (Matcher)Is.is(Optional.of(10)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_START_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(5)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_END_LINE.get(metadata), (Matcher)Is.is(Optional.of(11)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_END_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(32)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_START_LINE.get(metadata), (Matcher)Is.is(Optional.of(13)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_START_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(5)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_END_LINE.get(metadata), (Matcher)Is.is(Optional.of(13)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_END_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(28)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.IS_SELF_CLOSING.get(metadata).orElse(false), (Matcher)Is.is((Object)false));
    }

    @Test
    public void locationMetadataIsCorrectWhenSelfClosingTagsAreMultiline() throws URISyntaxException {
        String resourceName = "metadata/multiline-opening-tags.xml";
        URL resource = this.getClass().getResource("/metadata/multiline-opening-tags.xml");
        ArtifactAst simpleAst = this.parser.parse(new URL[]{resource});
        ComponentAst globalProperty = (ComponentAst)simpleAst.topLevelComponents().get(0);
        ComponentMetadataAst metadata = globalProperty.getMetadata();
        MatcherAssert.assertThat((Object)metadata.getStartLine().getAsInt(), (Matcher)Is.is((Object)8));
        MatcherAssert.assertThat((Object)metadata.getStartColumn().getAsInt(), (Matcher)Is.is((Object)5));
        MatcherAssert.assertThat((Object)metadata.getEndLine().getAsInt(), (Matcher)Is.is((Object)9));
        MatcherAssert.assertThat((Object)metadata.getEndColumn().getAsInt(), (Matcher)Is.is((Object)37));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_START_LINE.get(metadata), (Matcher)Is.is(Optional.of(8)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_START_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(5)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_END_LINE.get(metadata), (Matcher)Is.is(Optional.of(9)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.OPENING_TAG_END_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(37)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_START_LINE.get(metadata), (Matcher)Is.is(Optional.of(8)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_START_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(5)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_END_LINE.get(metadata), (Matcher)Is.is(Optional.of(9)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.CLOSING_TAG_END_COLUMN.get(metadata), (Matcher)Is.is(Optional.of(37)));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.IS_SELF_CLOSING.get(metadata), (Matcher)Is.is(Optional.of(true)));
    }
}

