/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.test.internal.xml.resolver;

import static org.junit.Assert.assertThrows;

import org.mule.runtime.ast.internal.xml.resolver.FailAfterTenErrorsResolveEntityFailStrategy;
import org.mule.runtime.ast.internal.xml.resolver.ResolveEntityFailStrategy;

import org.junit.Test;
import org.xml.sax.SAXException;

public class FailAfterTenErrorsResolveEntityFailStrategyTestCase {

  private static final int MAX_RESOLUTION_FAILURE_THRESHOLD = 10;
  ResolveEntityFailStrategy failStrategy = new FailAfterTenErrorsResolveEntityFailStrategy();

  @Test
  public void notFailsOnFirstAttempt() throws SAXException {
    failStrategy.execute("notExists", "notExists");
  }

  @Test
  public void FailsOnManyAttemps() {
    assertThrows("Can't resolve notExists (notExists), A dependency or plugin might be missing", SAXException.class,
                 this::executeManyTimes);
  }

  private void executeManyTimes() throws SAXException {
    for (int failures = 0; failures <= MAX_RESOLUTION_FAILURE_THRESHOLD; failures++) {
      failStrategy.execute("notExists", "notExists");
    }
  }


}
