/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.xml.resolver;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.mule.runtime.api.util.IOUtils;
import org.mule.runtime.api.util.classloader.MuleImplementationLoaderUtils;
import org.mule.runtime.dsl.internal.util.SchemaMappingsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class MuleCustomEntityResolver
implements EntityResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleCustomEntityResolver.class);
    private final ClassLoader classLoader;
    private final Map<String, String> muleSchemaMappings;
    private final Map<String, String> appPluginsSchemaMappings;

    public MuleCustomEntityResolver(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.muleSchemaMappings = this.getMuleSchemaMappings();
        this.appPluginsSchemaMappings = this.getAppPluginsSchemaMappings();
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        if (systemId != null) {
            InputSource source = MuleCustomEntityResolver.resolveEntityInClassloader(this.muleSchemaMappings, publicId, systemId, MuleImplementationLoaderUtils.getMuleImplementationsLoader());
            if (source == null) {
                source = MuleCustomEntityResolver.resolveEntityInClassloader(this.appPluginsSchemaMappings, publicId, systemId, this.classLoader);
            }
            return source;
        }
        return null;
    }

    private static InputSource resolveEntityInClassloader(Map<String, String> schemaMappings, String publicId, String systemId, ClassLoader cl) {
        String resourceLocation = schemaMappings.get(systemId);
        if (resourceLocation != null) {
            URL resource = cl.getResource(resourceLocation);
            if (resource == null) {
                LOGGER.debug("Couldn't find XML schema [" + systemId + "]: " + resourceLocation);
                return null;
            }
            try {
                InputStream is = IOUtils.getInputStreamWithCacheControl((URL)resource);
                InputSource source = new InputSource(is);
                source.setPublicId(publicId);
                source.setSystemId(systemId);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Found XML schema [" + systemId + "] in classpath: " + resourceLocation);
                }
                return source;
            }
            catch (IOException e) {
                LOGGER.warn("Error resolving entity [" + systemId + "]: " + resourceLocation, (Throwable)e);
            }
        }
        return null;
    }

    private Map<String, String> getMuleSchemaMappings() {
        Map schemaMappings = SchemaMappingsUtils.getMuleSchemasMappings();
        Map springMappings = SchemaMappingsUtils.getSpringSchemasMappings();
        schemaMappings.putAll(springMappings);
        return schemaMappings;
    }

    private ClassLoader getClassLoaderToUse(ClassLoader classLoader) {
        ClassLoader classLoaderToUse = classLoader;
        if (classLoaderToUse == null) {
            classLoaderToUse = MuleCustomEntityResolver.getDefaultClassLoader();
        }
        return classLoaderToUse;
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null && (cl = MuleImplementationLoaderUtils.getMuleImplementationsLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cl;
    }

    private Map<String, String> getAppPluginsSchemaMappings() {
        return SchemaMappingsUtils.getSchemaMappings((String)"META-INF/mule.schemas", () -> this.getClassLoaderToUse(this.classLoader));
    }
}

