/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.test.internal.xml.resolver;

import static org.junit.Assert.assertThrows;

import org.mule.runtime.ast.internal.xml.resolver.FailOnFirstErrorResolveEntityFailStrategy;
import org.mule.runtime.ast.internal.xml.resolver.ResolveEntityFailStrategy;

import org.junit.Test;
import org.xml.sax.SAXException;

public class FailOnFirstErrorResolveEntityFailStrategyTestCase {

  ResolveEntityFailStrategy failStrategy = new FailOnFirstErrorResolveEntityFailStrategy();

  @Test
  public void failOnFirstAttempt() throws SAXException {
    assertThrows("Can't resolve notExists (notExists), A dependency or plugin might be missing", SAXException.class,
                 () -> failStrategy.execute("notExists", "notExists"));
  }
}
