/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.test.internal.xml.resolver;

import static java.util.Collections.emptySet;
import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.junit.Assert.assertThrows;
import static org.mockito.Mockito.mock;
import static org.mule.runtime.dsl.internal.util.SchemaMappingsUtils.resolveSystemId;

import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.ast.internal.xml.resolver.FailAfterTenErrorsResolveEntityFailStrategy;
import org.mule.runtime.ast.internal.xml.resolver.FailOnFirstErrorResolveEntityFailStrategy;
import org.mule.runtime.ast.internal.xml.resolver.ModuleDelegatingEntityResolver;
import org.mule.runtime.extension.api.dsl.syntax.resources.spi.ExtensionSchemaGenerator;

import io.qameta.allure.Issue;
import org.junit.Test;
import org.xml.sax.SAXException;

public class ModuleDelegatingEntityResolverTestCase {

  @Test
  public void legacySpring() throws Exception {
    String systemId = resolveSystemId("http://www.springframework.org/schema/beans/spring-beans-current.xsd");
    assertThat(systemId, is("http://www.springframework.org/schema/beans/spring-beans.xsd"));
  }

  @Test
  public void failsOnMissing() throws Exception {
    final ModuleDelegatingEntityResolver resolver =
        new ModuleDelegatingEntityResolver(emptySet(), mock(ExtensionSchemaGenerator.class),
                                           mock(DslResolvingContext.class), new FailOnFirstErrorResolveEntityFailStrategy());

    assertThrows("Can't resolve notExists (notExists), A dependency or plugin might be missing", SAXException.class,
                 () -> resolver.resolveEntity("notExists", "notExists"));
  }

  @Test
  @Issue("MULE-19534")
  public void notFailsOnMissingIfLegacy() throws Exception {
    final ModuleDelegatingEntityResolver resolver =
        new ModuleDelegatingEntityResolver(emptySet(), mock(ExtensionSchemaGenerator.class),
                                           mock(DslResolvingContext.class), new FailAfterTenErrorsResolveEntityFailStrategy());

    resolver.resolveEntity("notExists", "notExists");
  }
}
