/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.test.internal.xml.reader;

import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsMapContaining;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mule.runtime.ast.api.NamespaceDefinition;
import org.mule.runtime.ast.api.builder.ArtifactAstBuilder;
import org.mule.runtime.ast.api.xml.AstXmlParserAttribute;
import org.mule.runtime.ast.internal.DefaultComponentMetadataAst;
import org.mule.runtime.ast.internal.builder.DefaultComponentAstBuilder;
import org.mule.runtime.ast.internal.builder.PropertiesResolver;
import org.mule.runtime.ast.internal.model.DefaultExtensionModelHelper;
import org.mule.runtime.ast.internal.xml.reader.ComponentAstReader;
import org.mule.runtime.dsl.api.ConfigResource;
import org.mule.runtime.dsl.api.xml.parser.XmlApplicationParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ComponentAstReaderTestCase {
    private static final ConfigResource TEST_CONFIG_RESOURCE;
    private final ComponentAstReader reader = new ComponentAstReader();
    private DocumentBuilder builder;
    private XmlApplicationParser parser;
    @Mock
    private ArtifactAstBuilder mockBuilder;
    @Captor
    private ArgumentCaptor<NamespaceDefinition> namespaceCaptor;

    @Before
    public void before() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        this.builder = factory.newDocumentBuilder();
        this.parser = (XmlApplicationParser)Mockito.mock(XmlApplicationParser.class);
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void emptyBody() throws ParserConfigurationException, SAXException, IOException {
        Document doc = this.createDoc("<mule></mule>");
        Mockito.when((Object)this.parser.parseIdentifier((Node)ArgumentMatchers.any())).thenReturn((Object)"comp");
        PropertiesResolver propertiesResolver = new PropertiesResolver();
        DefaultComponentAstBuilder compBuilder = new DefaultComponentAstBuilder(propertiesResolver, (DefaultExtensionModelHelper)Mockito.mock(DefaultExtensionModelHelper.class), Collections.emptyList(), 0);
        this.reader.extractComponentDefinitionModel(this.parser, doc.getDocumentElement(), TEST_CONFIG_RESOURCE.getResourceName(), TEST_CONFIG_RESOURCE.getUrl(), Collections.emptyList(), () -> compBuilder, () -> DefaultComponentMetadataAst.builder((PropertiesResolver)propertiesResolver));
        MatcherAssert.assertThat((Object)((String)compBuilder.getRawParameters().get("$%body%$")), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.IS_CDATA.get(compBuilder.getMetadata()).orElse(false), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void emptyBodyFormatted() throws ParserConfigurationException, SAXException, IOException {
        Document doc = this.createDoc("<mule>\n</mule>");
        Mockito.when((Object)this.parser.parseIdentifier((Node)ArgumentMatchers.any())).thenReturn((Object)"comp");
        PropertiesResolver propertiesResolver = new PropertiesResolver();
        DefaultComponentAstBuilder compBuilder = new DefaultComponentAstBuilder(propertiesResolver, (DefaultExtensionModelHelper)Mockito.mock(DefaultExtensionModelHelper.class), Collections.emptyList(), 0);
        this.reader.extractComponentDefinitionModel(this.parser, doc.getDocumentElement(), TEST_CONFIG_RESOURCE.getResourceName(), TEST_CONFIG_RESOURCE.getUrl(), Collections.emptyList(), () -> compBuilder, () -> DefaultComponentMetadataAst.builder((PropertiesResolver)propertiesResolver));
        MatcherAssert.assertThat((Object)((String)compBuilder.getRawParameters().get("$%body%$")), (Matcher)Matchers.is((Object)"\n"));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.IS_CDATA.get(compBuilder.getMetadata()).orElse(false), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void emptyCdataBody() throws ParserConfigurationException, SAXException, IOException {
        Document doc = this.createDoc("<mule><![CDATA[]]></mule>");
        Mockito.when((Object)this.parser.parseIdentifier((Node)ArgumentMatchers.any())).thenReturn((Object)"comp");
        PropertiesResolver propertiesResolver = new PropertiesResolver();
        DefaultComponentAstBuilder compBuilder = new DefaultComponentAstBuilder(propertiesResolver, (DefaultExtensionModelHelper)Mockito.mock(DefaultExtensionModelHelper.class), Collections.emptyList(), 0);
        this.reader.extractComponentDefinitionModel(this.parser, doc.getDocumentElement(), TEST_CONFIG_RESOURCE.getResourceName(), TEST_CONFIG_RESOURCE.getUrl(), Collections.emptyList(), () -> compBuilder, () -> DefaultComponentMetadataAst.builder((PropertiesResolver)propertiesResolver));
        MatcherAssert.assertThat((Object)((String)compBuilder.getRawParameters().get("$%body%$")), (Matcher)Matchers.is((Object)""));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.IS_CDATA.get(compBuilder.getMetadata()).orElse(false), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void emptyCdataBodyFormatted() throws ParserConfigurationException, SAXException, IOException {
        Document doc = this.createDoc("<mule>\n  <![CDATA[]]>\n</mule>");
        Mockito.when((Object)this.parser.parseIdentifier((Node)ArgumentMatchers.any())).thenReturn((Object)"comp");
        PropertiesResolver propertiesResolver = new PropertiesResolver();
        DefaultComponentAstBuilder compBuilder = new DefaultComponentAstBuilder(propertiesResolver, (DefaultExtensionModelHelper)Mockito.mock(DefaultExtensionModelHelper.class), Collections.emptyList(), 0);
        this.reader.extractComponentDefinitionModel(this.parser, doc.getDocumentElement(), TEST_CONFIG_RESOURCE.getResourceName(), TEST_CONFIG_RESOURCE.getUrl(), Collections.emptyList(), () -> compBuilder, () -> DefaultComponentMetadataAst.builder((PropertiesResolver)propertiesResolver));
        MatcherAssert.assertThat((Object)((String)compBuilder.getRawParameters().get("$%body%$")), (Matcher)Matchers.is((Object)""));
        MatcherAssert.assertThat((Object)AstXmlParserAttribute.IS_CDATA.get(compBuilder.getMetadata()).orElse(false), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void creatingNamespaceDefinition() throws SAXException, IOException {
        Document doc = this.createDoc("<module name=\"module-calling-operations-within-module\"\n        prefix=\"modified-prefix\"\n        namespace=\"http://www.mulesoft.org/schema/a/different/path/mule/module-calling-operations-within-module\"\n        xmlns:tns=\"http://www.mulesoft.org/schema/a/different/path/mule/module-calling-operations-within-module\"\n        xmlns=\"http://www.mulesoft.org/schema/mule/module\"\n        xmlns:mule=\"http://www.mulesoft.org/schema/mule/core\"\n        xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n        xsi:schemaLocation=\"\n           http://www.mulesoft.org/schema/mule/module http://www.mulesoft.org/schema/mule/module/current/mule-module.xsd\n           http://www.mulesoft.org/schema/mule/core http://www.mulesoft.org/schema/mule/core/current/mule.xsd\n           http://www.mulesoft.org/schema/a/different/path/mule/module-calling-operations-within-module http://www.mulesoft.org/schema/a/different/path/mule/module-calling-operations-within-module/current/mule-modified-prefix.xsd\"/>");
        this.reader.processAttributes(this.mockBuilder, doc.getDocumentElement());
        ((ArtifactAstBuilder)Mockito.verify((Object)this.mockBuilder)).withNamespaceDefinition((NamespaceDefinition)this.namespaceCaptor.capture());
        NamespaceDefinition definition = (NamespaceDefinition)this.namespaceCaptor.getValue();
        MatcherAssert.assertThat((Object)definition.getNamespace(), (Matcher)Matchers.is((Object)"http://www.mulesoft.org/schema/a/different/path/mule/module-calling-operations-within-module"));
        MatcherAssert.assertThat((Object)definition.getPrefix(), (Matcher)Matchers.is((Object)"modified-prefix"));
        MatcherAssert.assertThat((Object)definition.getSchemaLocations(), (Matcher)Matchers.is((Matcher)Matchers.aMapWithSize((int)3)));
        MatcherAssert.assertThat((Object)definition.getSchemaLocations(), (Matcher)IsMapContaining.hasEntry((Object)"http://www.mulesoft.org/schema/mule/module", (Object)"http://www.mulesoft.org/schema/mule/module/current/mule-module.xsd"));
        MatcherAssert.assertThat((Object)definition.getSchemaLocations(), (Matcher)IsMapContaining.hasEntry((Object)"http://www.mulesoft.org/schema/mule/core", (Object)"http://www.mulesoft.org/schema/mule/core/current/mule.xsd"));
        MatcherAssert.assertThat((Object)definition.getSchemaLocations(), (Matcher)IsMapContaining.hasEntry((Object)"http://www.mulesoft.org/schema/a/different/path/mule/module-calling-operations-within-module", (Object)"http://www.mulesoft.org/schema/a/different/path/mule/module-calling-operations-within-module/current/mule-modified-prefix.xsd"));
        MatcherAssert.assertThat((Object)definition.getUnresovedNamespaces(), (Matcher)IsMapContaining.hasEntry((Object)"xmlns:mule", (Object)"http://www.mulesoft.org/schema/mule/core"));
        MatcherAssert.assertThat((Object)definition.getUnresovedNamespaces(), (Matcher)IsMapContaining.hasEntry((Object)"xmlns", (Object)"http://www.mulesoft.org/schema/mule/module"));
        MatcherAssert.assertThat((Object)definition.getUnresovedNamespaces(), (Matcher)IsMapContaining.hasEntry((Object)"xmlns:tns", (Object)"http://www.mulesoft.org/schema/a/different/path/mule/module-calling-operations-within-module"));
        MatcherAssert.assertThat((Object)definition.getUnresovedNamespaces(), (Matcher)IsMapContaining.hasEntry((Object)"xmlns:xsi", (Object)"http://www.w3.org/2001/XMLSchema-instance"));
    }

    @Test
    @Issue(value="MULE-20035")
    @Description(value="Account for some incomplete schema locations that deployed properly on previous versions.")
    public void namespaceUriWithoutLocation() throws SAXException, IOException {
        Document doc = this.createDoc("<mule xmlns=\"http://www.mulesoft.org/schema/mule/core\"\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"http://www.mulesoft.org/schema/mule/core http://www.mulesoft.org/schema/mule/core/current/mule.xsd\n                          http://www.mulesoft.org/schema/mule/documentation\"/>\n");
        this.reader.processAttributes(this.mockBuilder, doc.getDocumentElement());
        ((ArtifactAstBuilder)Mockito.verify((Object)this.mockBuilder)).withNamespaceDefinition((NamespaceDefinition)this.namespaceCaptor.capture());
        NamespaceDefinition definition = (NamespaceDefinition)this.namespaceCaptor.getValue();
        MatcherAssert.assertThat((Object)definition.getSchemaLocations(), (Matcher)Matchers.is((Matcher)Matchers.aMapWithSize((int)1)));
        MatcherAssert.assertThat((Object)definition.getSchemaLocations(), (Matcher)IsMapContaining.hasEntry((Object)"http://www.mulesoft.org/schema/mule/core", (Object)"http://www.mulesoft.org/schema/mule/core/current/mule.xsd"));
    }

    @Test
    @Issue(value="MULE-20090")
    public void resolvesPropertiesOnAttributes() throws SAXException, IOException {
        Document doc = this.createDoc("<mule\nxmlns:doc=\"http://www.mulesoft.org/schema/mule/documentation\"\ndoc:name=\"comp\" doc:id=\"${resolved1}\" param=\"${resolved2}\"></mule>");
        Mockito.when((Object)this.parser.parseIdentifier((Node)ArgumentMatchers.any())).thenReturn((Object)"comp");
        PropertiesResolver propertiesResolver = new PropertiesResolver();
        propertiesResolver.setMappingFunction(unresolved -> unresolved.substring(2, unresolved.length() - 1));
        DefaultComponentAstBuilder compBuilder = new DefaultComponentAstBuilder(propertiesResolver, (DefaultExtensionModelHelper)Mockito.mock(DefaultExtensionModelHelper.class), Collections.emptyList(), 0);
        this.reader.extractComponentDefinitionModel(this.parser, doc.getDocumentElement(), TEST_CONFIG_RESOURCE.getResourceName(), TEST_CONFIG_RESOURCE.getUrl(), Collections.emptyList(), () -> compBuilder, () -> DefaultComponentMetadataAst.builder((PropertiesResolver)propertiesResolver));
        MatcherAssert.assertThat((Object)((String)compBuilder.getMetadata().getDocAttributes().get("id")), (Matcher)Matchers.is((Object)"resolved1"));
        MatcherAssert.assertThat((Object)((String)compBuilder.getRawParameters().get("param")), (Matcher)Matchers.is((Object)"${resolved2}"));
        MatcherAssert.assertThat(compBuilder.getAnnotations().get(String.format("{%s}id", "http://www.mulesoft.org/schema/mule/documentation")), (Matcher)Matchers.is((Object)"${resolved1}"));
    }

    private Document createDoc(String content) throws UnsupportedEncodingException, SAXException, IOException {
        StringBuilder xmlStringBuilder = new StringBuilder();
        xmlStringBuilder.append("<?xml version=\"1.0\"?> " + content);
        ByteArrayInputStream input = new ByteArrayInputStream(xmlStringBuilder.toString().getBytes("UTF-8"));
        return this.builder.parse(input);
    }

    static {
        try {
            TEST_CONFIG_RESOURCE = new ConfigResource("mule-config.xml");
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

