/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.test.internal.xml.resolver;

import io.qameta.allure.Issue;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.ast.internal.xml.resolver.MuleCustomEntityResolver;
import org.xml.sax.InputSource;

public class MuleCustomEntityResolverTestCase {
    private static final int TIMEOUT = 6000;
    private static final String MULE_FAKE_CORE = "http://www.mulesoft.org/schema/mule/core/current/mule-fake-core.xsd";
    private static final String JAR_NAME = "stuff.jar";
    private static final String MULE_SCHEMAS = "META-INF/mule.schemas";
    private static final String MULE_SCHEMAS_CONTENT = "http\\://www.mulesoft.org/schema/mule/core/current/mule-fake-core.xsd=META-INF/mule-fake-core.xsd";
    private static final String MULE_FAKE_CORE_XSD_FILE_NAME = "META-INF/mule-fake-core.xsd";
    private static final String MULE_FAKE_CONTENT = "schema-content";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    @Issue(value="MULE-18812")
    public void loadSchemasResourcesEvenWhenJarFileIsClosed() throws Exception {
        File jarFile = this.createDummyJar();
        URLClassLoader classLoader = new URLClassLoader(new URL[]{jarFile.toURI().toURL()});
        Latch latch = new Latch();
        MuleCustomEntityResolver entityResolver = new MuleCustomEntityResolver((ClassLoader)classLoader);
        InputSource is = entityResolver.resolveEntity(null, MULE_FAKE_CORE);
        MatcherAssert.assertThat((Object)is, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Thread thread = new Thread(() -> {
            try {
                JarURLConnection urlConnection = (JarURLConnection)classLoader.getResource(MULE_FAKE_CORE_XSD_FILE_NAME).openConnection();
                urlConnection.getJarFile().close();
            }
            catch (IOException e) {
                Assert.fail((String)"Unexpected exception was caught when trying to close jar file");
            }
            latch.release();
        });
        thread.start();
        latch.await(6000L, TimeUnit.MILLISECONDS);
        MatcherAssert.assertThat((Object)IOUtils.toString((InputStream)is.getByteStream()), (Matcher)CoreMatchers.is((Object)MULE_FAKE_CONTENT));
    }

    @Test
    @Issue(value="MULE-18812")
    public void loadSchemasResourcesEvenWhenUrlClassLoaderIsClosedWhileInputStreamIsBeingUsed() throws Exception {
        File jarFile = this.createDummyJar();
        URLClassLoader cl = new URLClassLoader(new URL[]{jarFile.toURI().toURL()});
        URLClassLoader cl2 = new URLClassLoader(new URL[]{jarFile.toURI().toURL()});
        Latch latch = new Latch();
        MuleCustomEntityResolver entityResolver = new MuleCustomEntityResolver((ClassLoader)cl);
        InputSource is = entityResolver.resolveEntity(null, MULE_FAKE_CORE);
        MatcherAssert.assertThat((Object)is, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Thread thread = new Thread(() -> {
            try {
                InputStream inputStream = cl2.getResourceAsStream(MULE_FAKE_CORE_XSD_FILE_NAME);
                MatcherAssert.assertThat((Object)inputStream, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
                MatcherAssert.assertThat((Object)IOUtils.toString((InputStream)inputStream), (Matcher)CoreMatchers.is((Object)MULE_FAKE_CONTENT));
                cl2.close();
            }
            catch (IOException e) {
                Assert.fail((String)"Unexpected exception was caught when trying to close jar file");
            }
            latch.release();
        });
        thread.start();
        latch.await(6000L, TimeUnit.MILLISECONDS);
        MatcherAssert.assertThat((Object)IOUtils.toString((InputStream)is.getByteStream()), (Matcher)CoreMatchers.is((Object)MULE_FAKE_CONTENT));
    }

    private File createDummyJar() throws IOException {
        File jarFile = this.temporaryFolder.newFile(JAR_NAME);
        try (JarOutputStream jar = new JarOutputStream(new FileOutputStream(jarFile));){
            jar.putNextEntry(new JarEntry(MULE_SCHEMAS));
            jar.write(MULE_SCHEMAS_CONTENT.getBytes());
            jar.closeEntry();
            jar.putNextEntry(new JarEntry(MULE_FAKE_CORE_XSD_FILE_NAME));
            jar.write(MULE_FAKE_CONTENT.getBytes());
            jar.closeEntry();
        }
        return jarFile;
    }
}

