/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.test.internal.xml.resolver;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.ast.test.internal.xml.DefaultAstXmlParserTestCase;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.dsl.syntax.resources.spi.ExtensionSchemaGenerator;

public class CachingExtensionSchemaGeneratorTestCase {
    private static int schemaGenerateCounter = 0;
    private ClassLoader classLoader;
    private AstXmlParser parser;
    private final Map<String, String> properties = new HashMap<String, String>();

    @BeforeClass
    public static void configureTestSchemaLoader() throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        Field schemaGeneratorField = AstXmlParser.Builder.class.getDeclaredField("SCHEMA_GENERATOR");
        schemaGeneratorField.setAccessible(true);
        schemaGeneratorField.set(null, Optional.of(new TestExtensionSchemaGenerator()));
    }

    @Before
    public void before() {
        schemaGenerateCounter = 0;
        this.properties.clear();
        this.classLoader = DefaultAstXmlParserTestCase.class.getClassLoader();
        this.parser = AstXmlParser.builder().withExtensionModel(this.getMockHeisenbergModel()).withPropertyResolver(propertyKey -> this.properties.getOrDefault(propertyKey, propertyKey)).build();
    }

    private ExtensionModel getMockHeisenbergModel() {
        return this.mockExtensionModel("Heisenberg");
    }

    private ExtensionModel mockExtensionModel(String name) {
        ExtensionModel model = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        String prefix = name.toLowerCase();
        Mockito.when((Object)model.getName()).thenReturn((Object)name);
        Mockito.when((Object)model.getXmlDslModel()).thenReturn((Object)XmlDslModel.builder().setNamespace("http://www.mulesoft.org/schema/mule/" + prefix).setSchemaLocation(String.format("http://www.mulesoft.org/schema/mule/%s/current/mule-%s.xsd", prefix, prefix)).setPrefix(prefix).build());
        return model;
    }

    @Test
    public void generatedSchemaIsCached() {
        this.parser.parse(new URL[]{this.classLoader.getResource("mule-config-with-extension.xml")});
        this.parser.parse(new URL[]{this.classLoader.getResource("mule-config-with-extension.xml")});
        MatcherAssert.assertThat((Object)schemaGenerateCounter, (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void applicationSchemaNotCached() {
        this.parser = AstXmlParser.builder().withSchemaValidationsDisabled().withExtensionModels(Arrays.asList(this.getMockHeisenbergModel(), this.mockExtensionModel("this"))).build();
        this.parser.parse(new URL[]{this.classLoader.getResource("hello-world-operation.xml")});
        this.parser.parse(new URL[]{this.classLoader.getResource("hello-world-operation.xml")});
        MatcherAssert.assertThat((Object)schemaGenerateCounter, (Matcher)Matchers.is((Object)0));
    }

    public static final class TestExtensionSchemaGenerator
    implements ExtensionSchemaGenerator {
        public String generate(ExtensionModel extensionModel, DslResolvingContext context) {
            schemaGenerateCounter++;
            if (extensionModel.getName().equals("Heisenberg")) {
                try {
                    return IOUtils.toString((URL)DefaultAstXmlParserTestCase.class.getClassLoader().getResource("META-INF/heisenberg.xsd"), (Charset)StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    throw new MuleRuntimeException((Throwable)e);
                }
            }
            return "";
        }

        public String generate(ExtensionModel extensionModel, DslResolvingContext context, DslSyntaxResolver dsl) {
            return this.generate(extensionModel, context);
        }
    }
}

