/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.test.internal.xml;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsMapContaining;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.xmlsecurity.XMLSecureFactories;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ImportedResource;
import org.mule.runtime.ast.api.exception.PropertyNotFoundException;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.dsl.api.xml.parser.XmlConfigurationDocumentLoader;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.helpers.DefaultHandler;

@Feature(value="Mule Artifact AST")
@Story(value="<import> handling")
public class DefaultAstXmlParserWithImportsTestCase {
    private static final XmlDslModel XML_DSL_MODEL = XmlDslModel.builder().setPrefix("mule").setNamespace("http://mockns").build();
    private ClassLoader classLoader;
    private AstXmlParser parser;
    private final Map<String, String> properties = new HashMap<String, String>();
    private final ExtensionModel mockedExtensionModel = (ExtensionModel)Mockito.mock(ExtensionModel.class);

    @Before
    public void before() {
        this.properties.clear();
        this.classLoader = DefaultAstXmlParserWithImportsTestCase.class.getClassLoader();
        ConstructModel topLevelSimpleConstruct = (ConstructModel)Mockito.mock(ConstructModel.class);
        Mockito.when((Object)topLevelSimpleConstruct.getName()).thenReturn((Object)"top-level-simple");
        ConstructModel topLevelSimpleOtherConstruct = (ConstructModel)Mockito.mock(ConstructModel.class);
        Mockito.when((Object)topLevelSimpleOtherConstruct.getName()).thenReturn((Object)"top-level-simple-other");
        ConstructModel topLevelImportConstruct = (ConstructModel)Mockito.mock(ConstructModel.class);
        Mockito.when((Object)topLevelImportConstruct.getName()).thenReturn((Object)"top-level-import");
        Mockito.when((Object)this.mockedExtensionModel.getName()).thenReturn((Object)"Mock Extension Model");
        Mockito.when((Object)this.mockedExtensionModel.getXmlDslModel()).thenReturn((Object)XML_DSL_MODEL);
        Mockito.when((Object)this.mockedExtensionModel.getConstructModels()).thenReturn(Arrays.asList(topLevelSimpleConstruct, topLevelImportConstruct, topLevelSimpleOtherConstruct));
        this.parser = AstXmlParser.builder().withSchemaValidationsDisabled().withExtensionModel(this.mockedExtensionModel).withPropertyResolver(propertyKey -> this.properties.getOrDefault(propertyKey, propertyKey)).build();
    }

    @Test
    public void imports() {
        ArtifactAst importAst = this.parser.parse(new URL[]{this.classLoader.getResource("import.xml")});
        List components = importAst.recursiveStream().map(c -> c.getIdentifier().toString()).collect(Collectors.toList());
        MatcherAssert.assertThat(components, (Matcher)Matchers.contains((Object[])new String[]{"top-level-import", "top-level-simple"}));
        List imports = importAst.getImportedResources().stream().map(ImportedResource::getResourceLocation).collect(Collectors.toList());
        MatcherAssert.assertThat(imports, (Matcher)Matchers.contains((Object[])new String[]{"simple.xml"}));
        Map<String, List<String>> filesToImportHierarchy = this.obtainFilesToImportHierarchy(importAst);
        MatcherAssert.assertThat(filesToImportHierarchy, (Matcher)IsMapContaining.hasEntry((Matcher)Matchers.is((Object)"simple.xml"), (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.startsWith((String)"file:/"), (Matcher)Matchers.endsWith((String)"/import.xml")))));
        MatcherAssert.assertThat(filesToImportHierarchy, (Matcher)IsMapContaining.hasEntry((Object)"import.xml", Collections.emptyList()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Issue(value="MULE-19940")
    public void importsAlreadyParsed() {
        Thread.currentThread().setContextClassLoader(new ClassLoader(Thread.currentThread().getContextClassLoader()){

            @Override
            public URL getResource(String name) {
                if (name.equals("simple.xml")) {
                    try {
                        return new File("src/test/resources/simple.xml").toURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
                return super.getResource(name);
            }
        });
        try {
            ArtifactAst importAst = this.parser.parse(new URL[]{this.classLoader.getResource("import.xml"), this.classLoader.getResource("simple.xml")});
            List components = importAst.recursiveStream().map(c -> c.getIdentifier().toString()).collect(Collectors.toList());
            MatcherAssert.assertThat(components, (Matcher)Matchers.contains((Object[])new String[]{"top-level-import", "top-level-simple"}));
            List imports = importAst.getImportedResources().stream().map(ImportedResource::getResourceLocation).collect(Collectors.toList());
            MatcherAssert.assertThat(imports, (Matcher)Matchers.contains((Object[])new String[]{"simple.xml"}));
            Map<String, List<String>> filesToImportHierarchy = this.obtainFilesToImportHierarchy(importAst);
            MatcherAssert.assertThat(filesToImportHierarchy, (Matcher)IsMapContaining.hasEntry((Object)"simple.xml", Collections.emptyList()));
            MatcherAssert.assertThat(filesToImportHierarchy, (Matcher)IsMapContaining.hasEntry((Object)"import.xml", Collections.emptyList()));
        }
        finally {
            Thread.currentThread().setContextClassLoader(Thread.currentThread().getContextClassLoader().getParent());
        }
    }

    @Test
    @Story(value="Artifact XML config DOM processong")
    public void importsDocuments() {
        Document document = XmlConfigurationDocumentLoader.noValidationDocumentLoader().loadDocument(() -> XMLSecureFactories.createDefault().getSAXParserFactory(), (EntityResolver)new DefaultHandler(), "import.xml", this.classLoader.getResourceAsStream("import.xml"), null);
        ArtifactAst importAst = this.parser.parseDocument(Arrays.asList(new Pair((Object)"import.xml", (Object)document)));
        List components = importAst.recursiveStream().map(c -> c.getIdentifier().toString()).collect(Collectors.toList());
        MatcherAssert.assertThat(components, (Matcher)Matchers.contains((Object[])new String[]{"top-level-import", "top-level-simple"}));
        List imports = importAst.getImportedResources().stream().map(ImportedResource::getResourceLocation).collect(Collectors.toList());
        MatcherAssert.assertThat(imports, (Matcher)Matchers.contains((Object[])new String[]{"simple.xml"}));
        Map<String, List<String>> filesToImportHierarchy = this.obtainFilesToImportHierarchy(importAst);
        MatcherAssert.assertThat(filesToImportHierarchy, (Matcher)IsMapContaining.hasEntry((Matcher)Matchers.is((Object)"simple.xml"), (Matcher)Matchers.contains((Object[])new String[]{"<no_file_uri>"})));
        MatcherAssert.assertThat(filesToImportHierarchy, (Matcher)IsMapContaining.hasEntry((Object)"import.xml", Collections.emptyList()));
    }

    @Test
    public void importsFromDependency() {
        ArtifactAst importAst = this.parser.parse(new URL[]{this.classLoader.getResource("import-from-dependency.xml")});
        List components = importAst.recursiveStream().map(c -> c.getIdentifier().toString()).collect(Collectors.toList());
        MatcherAssert.assertThat(components, (Matcher)Matchers.contains((Object[])new String[]{"top-level-import", "flow", "logger"}));
        List imports = importAst.getImportedResources().stream().map(ImportedResource::getResourceLocation).collect(Collectors.toList());
        MatcherAssert.assertThat(imports, (Matcher)Matchers.contains((Object[])new String[]{"reusable-flows.xml"}));
        Map<String, List<String>> filesToImportHierarchy = this.obtainFilesToImportHierarchy(importAst);
        MatcherAssert.assertThat(filesToImportHierarchy, (Matcher)IsMapContaining.hasEntry((Object)"import-from-dependency.xml", Collections.emptyList()));
        MatcherAssert.assertThat(filesToImportHierarchy, (Matcher)IsMapContaining.hasEntry((Matcher)Matchers.is((Object)"reusable-flows.xml"), (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.startsWith((String)"file:/"), (Matcher)Matchers.endsWith((String)"/import-from-dependency.xml")))));
    }

    @Test
    public void importsFromDependencyIndirect() {
        ArtifactAst importAst = this.parser.parse(new URL[]{this.classLoader.getResource("import-from-dependency-indirect.xml")});
        List components = importAst.recursiveStream().map(c -> c.getIdentifier().toString()).collect(Collectors.toList());
        MatcherAssert.assertThat(components, (Matcher)Matchers.contains((Object[])new String[]{"top-level-import", "flow", "logger"}));
        List imports = importAst.getImportedResources().stream().map(ImportedResource::getResourceLocation).collect(Collectors.toList());
        MatcherAssert.assertThat(imports, (Matcher)Matchers.contains((Object[])new String[]{"import-reusable-flows.xml", "reusable-flows.xml"}));
        Map<String, List<String>> filesToImportHierarchy = this.obtainFilesToImportHierarchy(importAst);
        MatcherAssert.assertThat(filesToImportHierarchy, (Matcher)IsMapContaining.hasEntry((Object)"import-from-dependency-indirect.xml", Collections.emptyList()));
        MatcherAssert.assertThat(filesToImportHierarchy, (Matcher)IsMapContaining.hasEntry((Matcher)Matchers.is((Object)"reusable-flows.xml"), (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.startsWith((String)"file:/"), (Matcher)Matchers.endsWith((String)"/import-from-dependency-indirect.xml")), Matchers.allOf((Matcher)Matchers.startsWith((String)"jar:file:/"), (Matcher)Matchers.containsString((String)"/mule-artifact-ast-mule-reusable-flows-"), (Matcher)Matchers.endsWith((String)".jar!/import-reusable-flows.xml"))})));
    }

    @Test
    public void importsWithProperty() {
        this.properties.put("${prop}", "simple.xml");
        ArtifactAst importAst = this.parser.parse(new URL[]{this.classLoader.getResource("import-property.xml")});
        List components = importAst.recursiveStream().map(c -> c.getIdentifier().toString()).collect(Collectors.toList());
        MatcherAssert.assertThat(components, (Matcher)Matchers.contains((Object[])new String[]{"top-level-import", "top-level-simple"}));
        List imports = importAst.getImportedResources().stream().map(ImportedResource::getResourceLocation).collect(Collectors.toList());
        MatcherAssert.assertThat(imports, (Matcher)Matchers.contains((Object[])new String[]{"simple.xml"}));
    }

    @Test
    @Issue(value="W-12143338")
    public void importsWithUnresolvableProperty() {
        this.parser = AstXmlParser.builder().withSchemaValidationsDisabled().withExtensionModel(this.mockedExtensionModel).withPropertyResolver(propertyKey -> {
            throw new PropertyNotFoundException(new Pair((Object)"hardcoded", (Object)"prop"));
        }).build();
        ArtifactAst importAst = this.parser.parse(new URL[]{this.classLoader.getResource("import-property.xml")});
        ImportedResource unresolvableImport = (ImportedResource)importAst.getImportedResources().iterator().next();
        MatcherAssert.assertThat((Object)((String)unresolvableImport.getResolutionFailure().get()), (Matcher)Matchers.is((Object)"Could not resolve imported resource '${prop}': Couldn't find configuration property value for key ${prop}"));
    }

    @Test
    public void importsWithPropertyChangingValue() {
        this.properties.put("${prop}", "simple.xml");
        ArtifactAst importAst = this.parser.parse(new URL[]{this.classLoader.getResource("import-property.xml")});
        List components = importAst.recursiveStream().map(c -> c.getIdentifier().toString()).collect(Collectors.toList());
        MatcherAssert.assertThat(components, (Matcher)Matchers.contains((Object[])new String[]{"top-level-import", "top-level-simple"}));
        List imports = importAst.getImportedResources().stream().map(ImportedResource::getResourceLocation).collect(Collectors.toList());
        MatcherAssert.assertThat(imports, (Matcher)Matchers.contains((Object[])new String[]{"simple.xml"}));
        importAst.updatePropertiesResolver(key -> {
            if (key.equals("${prop}")) {
                return "alternativeValue";
            }
            return null;
        });
        List changedImports = importAst.getImportedResources().stream().map(ImportedResource::getResourceLocation).collect(Collectors.toList());
        MatcherAssert.assertThat(changedImports, (Matcher)Matchers.contains((Object[])new String[]{"alternativeValue"}));
    }

    @Test
    public void importsTwoLevels() {
        this.properties.put("${prop}", "simple.xml");
        ArtifactAst importAst = this.parser.parse(new URL[]{this.classLoader.getResource("import-two-levels.xml")});
        List components = importAst.recursiveStream().map(c -> c.getIdentifier().toString()).collect(Collectors.toList());
        MatcherAssert.assertThat(components, (Matcher)Matchers.contains((Object[])new String[]{"top-level-import", "top-level-import", "top-level-simple", "top-level-import", "flow", "logger", "top-level-import"}));
        List imports = importAst.getImportedResources().stream().map(ImportedResource::getResourceLocation).collect(Collectors.toList());
        MatcherAssert.assertThat(imports, (Matcher)Matchers.contains((Object[])new String[]{"import.xml", "simple.xml", "import-from-dependency.xml", "reusable-flows.xml", "import-property.xml", "simple.xml"}));
        Map<String, List<String>> filesToImportHierarchy = this.obtainFilesToImportHierarchy(importAst);
        MatcherAssert.assertThat(filesToImportHierarchy, (Matcher)IsMapContaining.hasEntry((Matcher)Matchers.is((Object)"simple.xml"), (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.startsWith((String)"file:/"), (Matcher)Matchers.endsWith((String)"/import-two-levels.xml")), Matchers.allOf((Matcher)Matchers.startsWith((String)"file:/"), (Matcher)Matchers.endsWith((String)"/import.xml"))})));
        MatcherAssert.assertThat(filesToImportHierarchy, (Matcher)IsMapContaining.hasEntry((Matcher)Matchers.is((Object)"import-property.xml"), (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.startsWith((String)"file:/"), (Matcher)Matchers.endsWith((String)"/import-two-levels.xml")))));
        MatcherAssert.assertThat(filesToImportHierarchy, (Matcher)IsMapContaining.hasEntry((Object)"import-two-levels.xml", Collections.emptyList()));
        MatcherAssert.assertThat(filesToImportHierarchy, (Matcher)IsMapContaining.hasEntry((Matcher)Matchers.is((Object)"import.xml"), (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.startsWith((String)"file:/"), (Matcher)Matchers.endsWith((String)"/import-two-levels.xml")))));
        MatcherAssert.assertThat(filesToImportHierarchy, (Matcher)IsMapContaining.hasEntry((Matcher)Matchers.is((Object)"import-from-dependency.xml"), (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.startsWith((String)"file:/"), (Matcher)Matchers.endsWith((String)"/import-two-levels.xml")))));
        MatcherAssert.assertThat(filesToImportHierarchy, (Matcher)IsMapContaining.hasEntry((Matcher)Matchers.is((Object)"reusable-flows.xml"), (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.startsWith((String)"file:/"), (Matcher)Matchers.endsWith((String)"/import-two-levels.xml")), Matchers.allOf((Matcher)Matchers.startsWith((String)"file:/"), (Matcher)Matchers.endsWith((String)"/import-from-dependency.xml"))})));
    }

    @Test
    @Story(value="Artifact XML config DOM processong")
    public void importsTwoLevelsDocuments() {
        Document document = XmlConfigurationDocumentLoader.noValidationDocumentLoader().loadDocument(() -> XMLSecureFactories.createDefault().getSAXParserFactory(), (EntityResolver)new DefaultHandler(), "import-two-levels.xml", this.classLoader.getResourceAsStream("import-two-levels.xml"), null);
        this.properties.put("${prop}", "simple.xml");
        ArtifactAst importAst = this.parser.parseDocument(Arrays.asList(new Pair((Object)"import-two-levels.xml", (Object)document)));
        List components = importAst.recursiveStream().map(c -> c.getIdentifier().toString()).collect(Collectors.toList());
        MatcherAssert.assertThat(components, (Matcher)Matchers.contains((Object[])new String[]{"top-level-import", "top-level-import", "top-level-simple", "top-level-import", "flow", "logger", "top-level-import"}));
        List imports = importAst.getImportedResources().stream().map(ImportedResource::getResourceLocation).collect(Collectors.toList());
        MatcherAssert.assertThat(imports, (Matcher)Matchers.contains((Object[])new String[]{"import.xml", "simple.xml", "import-from-dependency.xml", "reusable-flows.xml", "import-property.xml", "simple.xml"}));
        Map<String, List<String>> filesToImportHierarchy = this.obtainFilesToImportHierarchy(importAst);
        MatcherAssert.assertThat(filesToImportHierarchy, (Matcher)IsMapContaining.hasEntry((Matcher)Matchers.is((Object)"simple.xml"), (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.is((Object)"<no_file_uri>"), Matchers.allOf((Matcher)Matchers.startsWith((String)"file:/"), (Matcher)Matchers.endsWith((String)"/import.xml"))})));
        MatcherAssert.assertThat(filesToImportHierarchy, (Matcher)IsMapContaining.hasEntry((Matcher)Matchers.is((Object)"import-property.xml"), (Matcher)Matchers.contains((Object[])new String[]{"<no_file_uri>"})));
        MatcherAssert.assertThat(filesToImportHierarchy, (Matcher)IsMapContaining.hasEntry((Object)"import-two-levels.xml", Collections.emptyList()));
        MatcherAssert.assertThat(filesToImportHierarchy, (Matcher)IsMapContaining.hasEntry((Matcher)Matchers.is((Object)"import.xml"), (Matcher)Matchers.contains((Object[])new String[]{"<no_file_uri>"})));
        MatcherAssert.assertThat(filesToImportHierarchy, (Matcher)IsMapContaining.hasEntry((Matcher)Matchers.is((Object)"import-from-dependency.xml"), (Matcher)Matchers.contains((Object[])new String[]{"<no_file_uri>"})));
        MatcherAssert.assertThat(filesToImportHierarchy, (Matcher)IsMapContaining.hasEntry((Matcher)Matchers.is((Object)"reusable-flows.xml"), (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.is((Object)"<no_file_uri>"), Matchers.allOf((Matcher)Matchers.startsWith((String)"file:/"), (Matcher)Matchers.endsWith((String)"/import-from-dependency.xml"))})));
    }

    private Map<String, List<String>> obtainFilesToImportHierarchy(ArtifactAst importAst) {
        Map filesToImportHierarchy = importAst.recursiveStream().collect(Collectors.toMap(c -> (String)c.getMetadata().getFileName().get(), c -> c.getMetadata().getImportChain().stream().map(imp -> imp.getMetadata().getFileUri().map(Object::toString).orElse("<no_file_uri>")).collect(Collectors.toList()), (k, u) -> u, HashMap::new));
        return filesToImportHierarchy;
    }

    @Test
    public void twoConfigsAndImport() {
        ArtifactAst importAst = this.parser.parse(new URL[]{this.classLoader.getResource("import.xml"), this.classLoader.getResource("simple-other.xml")});
        List components = importAst.recursiveStream().map(c -> c.getIdentifier().toString()).collect(Collectors.toList());
        MatcherAssert.assertThat(components, (Matcher)Matchers.contains((Object[])new String[]{"top-level-import", "top-level-simple-other", "top-level-simple"}));
        List imports = importAst.getImportedResources().stream().map(ImportedResource::getResourceLocation).collect(Collectors.toList());
        MatcherAssert.assertThat(imports, (Matcher)Matchers.contains((Object[])new String[]{"simple.xml"}));
    }

    @Test
    public void twoConfigsAndImportSame() {
        ArtifactAst importAst = this.parser.parse(new URL[]{this.classLoader.getResource("import.xml"), this.classLoader.getResource("simple.xml")});
        List components = importAst.recursiveStream().map(c -> c.getIdentifier().toString()).collect(Collectors.toList());
        MatcherAssert.assertThat(components, (Matcher)Matchers.contains((Object[])new String[]{"top-level-import", "top-level-simple"}));
        List imports = importAst.getImportedResources().stream().map(ImportedResource::getResourceLocation).collect(Collectors.toList());
        MatcherAssert.assertThat(imports, (Matcher)Matchers.contains((Object[])new String[]{"simple.xml"}));
    }

    @Test
    public void twoConfigsAndImportSameInverse() {
        ArtifactAst importAst = this.parser.parse(new URL[]{this.classLoader.getResource("simple.xml"), this.classLoader.getResource("import.xml")});
        List components = importAst.recursiveStream().map(c -> c.getIdentifier().toString()).collect(Collectors.toList());
        MatcherAssert.assertThat(components, (Matcher)Matchers.contains((Object[])new String[]{"top-level-simple", "top-level-import"}));
        List imports = importAst.getImportedResources().stream().map(ImportedResource::getResourceLocation).collect(Collectors.toList());
        MatcherAssert.assertThat(imports, (Matcher)Matchers.contains((Object[])new String[]{"simple.xml"}));
    }

    @Test
    public void twoConfigsAndImportSameWithProperty() {
        this.properties.put("${prop}", "simple.xml");
        ArtifactAst importAst = this.parser.parse(new URL[]{this.classLoader.getResource("import.xml"), this.classLoader.getResource("import-property.xml")});
        List components = importAst.recursiveStream().map(c -> c.getIdentifier().toString()).collect(Collectors.toList());
        MatcherAssert.assertThat(components, (Matcher)Matchers.contains((Object[])new String[]{"top-level-import", "top-level-import", "top-level-simple"}));
        List imports = importAst.getImportedResources().stream().map(ImportedResource::getResourceLocation).collect(Collectors.toList());
        MatcherAssert.assertThat(imports, (Matcher)Matchers.contains((Object[])new String[]{"simple.xml", "simple.xml"}));
    }

    @Test
    public void unresolvableImport() {
        ArtifactAst importAst = this.parser.parse(new URL[]{this.classLoader.getResource("import-unresolvable.xml")});
        ImportedResource unresolvableImport = (ImportedResource)importAst.getImportedResources().iterator().next();
        MatcherAssert.assertThat((Object)((String)unresolvableImport.getResolutionFailure().get()), (Matcher)Matchers.is((Object)"Could not find imported resource 'doesnt_exist.xml'"));
    }

    @Test
    public void scrambledImportTarget() {
        ArtifactAst importAst = this.parser.parse(new URL[]{this.classLoader.getResource("import-scrambled.xml")});
        ImportedResource scrambledImport = (ImportedResource)importAst.getImportedResources().iterator().next();
        MatcherAssert.assertThat((Object)((String)scrambledImport.getResolutionFailure().get()), (Matcher)Matchers.is((Object)"Error loading: mule-config-scrambled.xml, Content is not allowed in prolog."));
    }

    @Test
    @Issue(value="W-15509819")
    public void differentTypeImportTarget() {
        ArtifactAst importAst = this.parser.parse(new URL[]{this.classLoader.getResource("import-different-type.xml")});
        ImportedResource differentTypeImport = (ImportedResource)importAst.getImportedResources().iterator().next();
        MatcherAssert.assertThat((Object)((String)differentTypeImport.getResolutionFailure().get()), (Matcher)Matchers.is((Object)"Imported resource 'mule-config-different-type.xml' declares a 'DOMAIN', not a 'APPLICATION'"));
        List components = importAst.recursiveStream().map(c -> c.getIdentifier().toString()).collect(Collectors.toList());
        MatcherAssert.assertThat(components, (Matcher)Matchers.contains((Object[])new String[]{"top-level-simple"}));
    }
}

