/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.api;

import java.util.Spliterator;
import java.util.stream.Stream;

/**
 * Represents a Mule artifact and provides access to its contents.
 *
 * @since 1.0
 */
public interface ArtifactAst {

  /**
   *
   * @return a {@link Stream} for this component and its children recursively that navigates the whole AST.
   */
  Stream<ComponentAst> recursiveStream();

  /**
   *
   * @return a {@link Spliterator} for this component and its children recursively that navigates the whole AST.
   */
  Spliterator<ComponentAst> recursiveSpliterator();

  /**
   *
   * @return a {@link Stream} for the top-level components (i.e.: configs, flows) of the artifact represented by this AST.
   */
  Stream<ComponentAst> topLevelComponentsStream();

  /**
   *
   * @return a {@link Spliterator} for the top-level components (i.e.: configs, flows) of the artifact represented by this AST.
   */
  Spliterator<ComponentAst> topLevelComponentsSpliterator();

}
