/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal;

import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;

import java.util.Spliterator;
import java.util.function.Predicate;
import java.util.stream.Stream;


public class FilteredArtifactAst implements ArtifactAst {

  private final ArtifactAst fullArtifactAst;

  private final Predicate<ComponentAst> componentFilter;

  public FilteredArtifactAst(ArtifactAst fullArtifactAst, Predicate<ComponentAst> componentFilter) {
    this.fullArtifactAst = fullArtifactAst;
    this.componentFilter = componentFilter;
  }

  @Override
  public Stream<ComponentAst> recursiveStream() {
    return fullArtifactAst.recursiveStream().filter(componentFilter);
  }

  @Override
  public Spliterator<ComponentAst> recursiveSpliterator() {
    return recursiveStream().spliterator();
  }

  @Override
  public Stream<ComponentAst> topLevelComponentsStream() {
    return fullArtifactAst.topLevelComponentsStream().filter(componentFilter);
  }

  @Override
  public Spliterator<ComponentAst> topLevelComponentsSpliterator() {
    return topLevelComponentsStream().spliterator();
  }

}
