/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.api.util;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;

public final class MuleAstUtils {
    private static final ArtifactAst EMPTY_ARTIFACT = new ArtifactAst(){

        @Override
        public Stream<ComponentAst> topLevelComponentsStream() {
            return Collections.emptySet().stream();
        }

        @Override
        public Spliterator<ComponentAst> topLevelComponentsSpliterator() {
            return Collections.emptySet().spliterator();
        }

        @Override
        public Stream<ComponentAst> recursiveStream() {
            return Collections.emptySet().stream();
        }

        @Override
        public Spliterator<ComponentAst> recursiveSpliterator() {
            return Collections.emptySet().spliterator();
        }
    };

    private MuleAstUtils() {
    }

    public static Set<ComponentAst> resolveOrphanComponents(ArtifactAst appModel) {
        Set notOrphanComponents = appModel.topLevelComponentsStream().flatMap(ComponentAst::recursiveStream).collect(Collectors.toSet());
        notOrphanComponents.addAll(appModel.recursiveStream().filter(cm -> !notOrphanComponents.contains(cm)).flatMap(ComponentAst::directChildrenStream).collect(Collectors.toSet()));
        return appModel.recursiveStream().filter(cm -> !notOrphanComponents.contains(cm)).collect(Collectors.toSet());
    }

    public static ArtifactAst emptyArtifact() {
        return EMPTY_ARTIFACT;
    }

    public static Optional<ComponentParameterAst> parameterOfType(ComponentAst referent, StereotypeModel referenceStereotype) {
        return referent.getModel(ParameterizedModel.class).flatMap(parameterized -> parameterized.getAllParameterModels().stream().filter(paramModel -> paramModel.getAllowedStereotypes().stream().anyMatch(allowed -> allowed.isAssignableTo(referenceStereotype))).map(paramModel -> referent.getParameter(paramModel.getName())).findAny());
    }
}

