/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.api;

import org.mule.runtime.ast.internal.DefaultComponentMetadataAst;

import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;

public interface ComponentMetadataAst {

  public static Builder builder() {
    return new DefaultComponentMetadataAst.Builder();
  }

  /**
   * @return the config file name in which the owner component was defined. It may be empty if the component was created
   *         programmatically.
   */
  Optional<String> getFileName();

  /**
   * @return the first line number in which the component was defined in the configuration file. It may be empty if the component
   *         was created programmatically.
   */
  OptionalInt getStartLine();

  /**
   * @return the start column in which the component was defined in the configuration file. It may be empty if the component was
   *         created programmatically.
   */
  OptionalInt getStartColumn();

  /**
   * @return the last line number in which the component was defined in the configuration file. It may be empty if the component
   *         was created programmatically.
   */
  OptionalInt getEndLine();

  /**
   * @return the end column in which the component was defined in the configuration file. It may be empty if the component was
   *         created programmatically.
   */
  OptionalInt getEndColumn();

  /**
   * @return the source code associated with the owner component. It may be empty if the component was created programmatically.
   */
  Optional<String> getSourceCode();

  /**
   * @return a {@code java.util.Map} with the doc metadata from the source config.
   */
  Map<String, String> getDocAttributes();

  /**
   * @return a {@code java.util.Map} with metadata from the parser.
   */
  Map<String, Object> getParserAttributes();

  public interface Builder {

    Builder setFileName(String fileName);

    Builder setStartLine(int startLine);

    Builder setStartColumn(int startColumn);

    Builder setEndLine(int endLine);

    Builder setEndColumn(int endColumn);

    Builder setSourceCode(String sourceCode);

    Builder putDocAttribute(String key, String value);

    Builder putParserAttribute(String key, Object value);

    ComponentMetadataAst build();
  }
}
