/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.api.util;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsCollectionContaining;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.stereotype.ImmutableStereotypeModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.MuleAstUtils;

public class MuleAstUtilsTestCase {
    @Test
    public void orphanComponentsTopLevelWithChildren() {
        ArtifactAst artifact = (ArtifactAst)Mockito.mock(ArtifactAst.class);
        ComponentAst processor = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)processor.directChildrenStream()).thenAnswer(inv -> Stream.empty());
        Mockito.when((Object)processor.recursiveStream()).thenAnswer(inv -> Stream.of(processor));
        ComponentAst topLevelComponent = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)topLevelComponent.directChildrenStream()).thenAnswer(inv -> Stream.of(processor));
        Mockito.when((Object)topLevelComponent.recursiveStream()).thenAnswer(inv -> Stream.of(topLevelComponent, processor));
        Mockito.when((Object)artifact.topLevelComponentsStream()).thenAnswer(inv -> Stream.of(topLevelComponent));
        Mockito.when((Object)artifact.recursiveStream()).thenAnswer(inv -> Stream.of(topLevelComponent, processor));
        Set orphanComponents = MuleAstUtils.resolveOrphanComponents((ArtifactAst)artifact);
        Assert.assertThat((Object)orphanComponents, (Matcher)IsNot.not((Matcher)IsCollectionContaining.hasItem((Object)topLevelComponent)));
        Assert.assertThat((Object)orphanComponents, (Matcher)IsNot.not((Matcher)IsCollectionContaining.hasItem((Object)processor)));
    }

    @Test
    public void orphanComponentsSingleProcessor() {
        ArtifactAst artifact = (ArtifactAst)Mockito.mock(ArtifactAst.class);
        ComponentAst orphanProcessor = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)orphanProcessor.directChildrenStream()).thenAnswer(inv -> Stream.empty());
        Mockito.when((Object)orphanProcessor.recursiveStream()).thenAnswer(inv -> Stream.of(orphanProcessor));
        Mockito.when((Object)artifact.topLevelComponentsStream()).thenAnswer(inv -> Stream.empty());
        Mockito.when((Object)artifact.recursiveStream()).thenAnswer(inv -> Stream.of(orphanProcessor));
        Set orphanComponents = MuleAstUtils.resolveOrphanComponents((ArtifactAst)artifact);
        Assert.assertThat((Object)orphanComponents, (Matcher)IsCollectionContaining.hasItem((Object)orphanProcessor));
    }

    @Test
    public void orphanComponentsNestedProcessor() {
        ArtifactAst artifact = (ArtifactAst)Mockito.mock(ArtifactAst.class);
        ComponentAst nestedProcessor = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)nestedProcessor.directChildrenStream()).thenAnswer(inv -> Stream.empty());
        Mockito.when((Object)nestedProcessor.recursiveStream()).thenAnswer(inv -> Stream.of(nestedProcessor));
        ComponentAst orphanRouter = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)orphanRouter.directChildrenStream()).thenAnswer(inv -> Stream.of(nestedProcessor));
        Mockito.when((Object)orphanRouter.recursiveStream()).thenAnswer(inv -> Stream.of(orphanRouter, nestedProcessor));
        Mockito.when((Object)artifact.topLevelComponentsStream()).thenAnswer(inv -> Stream.empty());
        Mockito.when((Object)artifact.recursiveStream()).thenAnswer(inv -> Stream.of(nestedProcessor, orphanRouter));
        Set orphanComponents = MuleAstUtils.resolveOrphanComponents((ArtifactAst)artifact);
        Assert.assertThat((Object)orphanComponents, (Matcher)IsCollectionContaining.hasItem((Object)orphanRouter));
        Assert.assertThat((Object)orphanComponents, (Matcher)IsNot.not((Matcher)IsCollectionContaining.hasItem((Object)nestedProcessor)));
    }

    @Test
    public void parameterOfTypeSameStereotype() {
        ImmutableStereotypeModel myOwnStereotype = new ImmutableStereotypeModel("MY_OWN", "MINE", null);
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel.getAllowedStereotypes()).thenReturn(Collections.singletonList(myOwnStereotype));
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)"myOwnParam");
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        Mockito.when((Object)parameterizedModel.getAllParameterModels()).thenReturn(Collections.singletonList(parameterModel));
        ComponentParameterAst parameter = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        ComponentAst comp = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)comp.getModel(ParameterizedModel.class)).thenReturn(Optional.of(parameterizedModel));
        Mockito.when((Object)comp.getParameter("myOwnParam")).thenReturn((Object)parameter);
        Assert.assertThat(MuleAstUtils.parameterOfType((ComponentAst)comp, (StereotypeModel)myOwnStereotype).get(), (Matcher)CoreMatchers.sameInstance((Object)parameter));
    }

    @Test
    public void parameterOfTypeParentStereotype() {
        ImmutableStereotypeModel myOwnParentStereotype = new ImmutableStereotypeModel("MY_OWN", "MINE", null);
        ImmutableStereotypeModel myOwnStereotype = new ImmutableStereotypeModel("MY_PRECIOUS", "MINE", (StereotypeModel)myOwnParentStereotype);
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel.getAllowedStereotypes()).thenReturn(Collections.singletonList(myOwnStereotype));
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)"myOwnParam");
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        Mockito.when((Object)parameterizedModel.getAllParameterModels()).thenReturn(Collections.singletonList(parameterModel));
        ComponentParameterAst parameter = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        ComponentAst comp = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)comp.getModel(ParameterizedModel.class)).thenReturn(Optional.of(parameterizedModel));
        Mockito.when((Object)comp.getParameter("myOwnParam")).thenReturn((Object)parameter);
        Assert.assertThat(MuleAstUtils.parameterOfType((ComponentAst)comp, (StereotypeModel)myOwnParentStereotype).get(), (Matcher)CoreMatchers.sameInstance((Object)parameter));
    }

    @Test
    public void parameterOfTypeNotMatchingStereotype() {
        ImmutableStereotypeModel myOwnStereotype = new ImmutableStereotypeModel("MY_PRECIOUS", "MINE", null);
        ImmutableStereotypeModel myOtherStereotype = new ImmutableStereotypeModel("A_SWORD", "MINE", null);
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel.getAllowedStereotypes()).thenReturn(Collections.singletonList(myOwnStereotype));
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)"myOwnParam");
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        Mockito.when((Object)parameterizedModel.getAllParameterModels()).thenReturn(Collections.singletonList(parameterModel));
        ComponentParameterAst parameter = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        ComponentAst comp = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)comp.getModel(ParameterizedModel.class)).thenReturn(Optional.of(parameterizedModel));
        Mockito.when((Object)comp.getParameter("myOwnParam")).thenReturn((Object)parameter);
        Assert.assertThat((Object)MuleAstUtils.parameterOfType((ComponentAst)comp, (StereotypeModel)myOtherStereotype).isPresent(), (Matcher)Is.is((Object)false));
    }
}

