/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.api;

import java.util.function.UnaryOperator;

/**
 * Represents a resource that can be imported by an artifact.
 */
public interface ImportedResource {

  /**
   * @return the imported resource file location.
   */
  String getResourceLocation();

  /**
   * @return the metadata from the import declaration in the DSL.
   */
  ComponentMetadataAst getMetadata();

  /**
   * Updates the properties resolution callback.
   *
   * @param propertiesResolver The new property resolution callback.
   */
  void updatePropertiesResolver(UnaryOperator<String> propertiesResolver);
}
