/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.validation;

import static org.mule.runtime.ast.api.validation.ValidationResultItem.create;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.collection.IsCollectionWithSize.hasSize;
import static org.mockito.Mockito.mock;

import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.validation.Validation;

import org.junit.Test;

import io.qameta.allure.Issue;

public class DefaultValidationResultTestCase {

  @Test
  public void duplicateComponentFilter() {
    DefaultValidationResult result = new DefaultValidationResult();

    ComponentAst componentA = mock(ComponentAst.class);
    Validation validationA = mock(Validation.class);

    result.addItem(create(componentA, validationA, "failed :("));
    result.addItem(create(componentA, validationA, "failed :("));

    assertThat(result.getItems(), hasSize(1));
  }

  @Test
  @Issue("MULE-19963")
  public void notDuplicateComponentFilter() {
    DefaultValidationResult result = new DefaultValidationResult();

    ComponentAst componentA = mock(ComponentAst.class);
    ComponentAst componentB = mock(ComponentAst.class);
    Validation validationA = mock(Validation.class);

    result.addItem(create(componentA, validationA, "failed :("));
    result.addItem(create(componentB, validationA, "failed :("));

    assertThat(result.getItems(), hasSize(2));
  }

  @Test
  public void duplicateParameterFilter() {
    DefaultValidationResult result = new DefaultValidationResult();

    ComponentAst componentA = mock(ComponentAst.class);
    ComponentParameterAst paramA = mock(ComponentParameterAst.class);
    Validation validationA = mock(Validation.class);

    result.addItem(create(componentA, paramA, validationA, "failed :("));
    result.addItem(create(componentA, paramA, validationA, "failed :("));

    assertThat(result.getItems(), hasSize(1));
  }

  @Test
  @Issue("MULE-19963")
  public void notDuplicateParameterFilter() {
    DefaultValidationResult result = new DefaultValidationResult();

    ComponentAst componentA = mock(ComponentAst.class);
    ComponentParameterAst paramA = mock(ComponentParameterAst.class);
    ComponentParameterAst paramB = mock(ComponentParameterAst.class);
    Validation validationA = mock(Validation.class);

    result.addItem(create(componentA, paramA, validationA, "failed :("));
    result.addItem(create(componentA, paramB, validationA, "failed :("));

    assertThat(result.getItems(), hasSize(2));
  }
}
