/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.api.util;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.collection.IsEmptyCollection;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsCollectionContaining;
import org.hamcrest.core.IsNot;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.stereotype.ImmutableStereotypeModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.AstTraversalDirection;
import org.mule.runtime.ast.api.util.BaseArtifactAst;
import org.mule.runtime.ast.api.util.BaseComponentAst;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.api.util.TestUtils;

public class MuleAstUtilsTestCase {
    @Test
    public void orphanComponentsTopLevelWithChildren() {
        ArtifactAst artifact = (ArtifactAst)Mockito.mock(BaseArtifactAst.class);
        ComponentAst processor = this.mockBaseComponentAst();
        Mockito.when((Object)processor.directChildrenStream()).thenAnswer(inv -> Stream.empty());
        Mockito.when((Object)processor.recursiveStream()).thenAnswer(inv -> Stream.of(processor));
        ComponentAst topLevelComponent = this.mockBaseComponentAst();
        Mockito.when((Object)topLevelComponent.directChildrenStream()).thenAnswer(inv -> Stream.of(processor));
        Mockito.when((Object)topLevelComponent.recursiveStream()).thenAnswer(inv -> Stream.of(topLevelComponent, processor));
        Mockito.when((Object)artifact.topLevelComponentsStream()).thenAnswer(inv -> Stream.of(topLevelComponent));
        Mockito.when((Object)artifact.recursiveStream()).thenAnswer(inv -> Stream.of(topLevelComponent, processor));
        Mockito.when((Object)artifact.filteredComponents((Predicate)ArgumentMatchers.any())).thenCallRealMethod();
        Set orphanComponents = MuleAstUtils.resolveOrphanComponents((ArtifactAst)artifact);
        MatcherAssert.assertThat((Object)orphanComponents, (Matcher)IsNot.not((Matcher)IsCollectionContaining.hasItem((Object)topLevelComponent)));
        MatcherAssert.assertThat((Object)orphanComponents, (Matcher)IsNot.not((Matcher)IsCollectionContaining.hasItem((Object)processor)));
    }

    private ComponentAst mockBaseComponentAst() {
        ComponentAst theMock = (ComponentAst)Mockito.mock(BaseComponentAst.class);
        Mockito.when((Object)theMock.getModel(ParameterizedModel.class)).thenReturn(Optional.of(Mockito.mock(ParameterizedModel.class)));
        return theMock;
    }

    @Test
    public void orphanComponentsSingleProcessor() {
        ArtifactAst artifact = (ArtifactAst)Mockito.mock(BaseArtifactAst.class);
        ComponentAst orphanProcessor = this.mockBaseComponentAst();
        Mockito.when((Object)orphanProcessor.directChildrenStream()).thenAnswer(inv -> Stream.empty());
        Mockito.when((Object)orphanProcessor.recursiveStream()).thenAnswer(inv -> Stream.of(orphanProcessor));
        Mockito.when((Object)artifact.topLevelComponentsStream()).thenAnswer(inv -> Stream.empty());
        Mockito.when((Object)artifact.recursiveStream()).thenAnswer(inv -> Stream.of(orphanProcessor));
        Mockito.when((Object)artifact.filteredComponents((Predicate)ArgumentMatchers.any())).thenCallRealMethod();
        Set orphanComponents = MuleAstUtils.resolveOrphanComponents((ArtifactAst)artifact);
        MatcherAssert.assertThat((Object)orphanComponents, (Matcher)IsCollectionContaining.hasItem((Object)orphanProcessor));
    }

    @Test
    public void orphanComponentsNestedProcessor() {
        ArtifactAst artifact = (ArtifactAst)Mockito.mock(BaseArtifactAst.class);
        ComponentAst nestedProcessor = this.mockBaseComponentAst();
        Mockito.when((Object)nestedProcessor.directChildrenStream()).thenAnswer(inv -> Stream.empty());
        Mockito.when((Object)nestedProcessor.recursiveStream()).thenAnswer(inv -> Stream.of(nestedProcessor));
        ComponentAst orphanRouter = this.mockBaseComponentAst();
        Mockito.when((Object)orphanRouter.directChildrenStream()).thenAnswer(inv -> Stream.of(nestedProcessor));
        Mockito.when((Object)orphanRouter.recursiveStream()).thenAnswer(inv -> Stream.of(orphanRouter, nestedProcessor));
        Mockito.when((Object)artifact.topLevelComponentsStream()).thenAnswer(inv -> Stream.empty());
        Mockito.when((Object)artifact.recursiveStream()).thenAnswer(inv -> Stream.of(nestedProcessor, orphanRouter));
        Mockito.when((Object)artifact.filteredComponents((Predicate)ArgumentMatchers.any())).thenCallRealMethod();
        Set orphanComponents = MuleAstUtils.resolveOrphanComponents((ArtifactAst)artifact);
        MatcherAssert.assertThat((Object)orphanComponents, (Matcher)IsCollectionContaining.hasItem((Object)orphanRouter));
        MatcherAssert.assertThat((Object)orphanComponents, (Matcher)IsNot.not((Matcher)IsCollectionContaining.hasItem((Object)nestedProcessor)));
    }

    @Test
    public void parameterOfTypeSameStereotype() {
        ImmutableStereotypeModel myOwnStereotype = new ImmutableStereotypeModel("MY_OWN", "MINE", null);
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel.getAllowedStereotypes()).thenReturn(Collections.singletonList(myOwnStereotype));
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)"myOwnParam");
        ParameterGroupModel groupModel = TestUtils.createMockParameterGroup("General", parameterModel);
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        Mockito.when((Object)parameterizedModel.getParameterGroupModels()).thenReturn(Collections.singletonList(groupModel));
        ComponentParameterAst parameter = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        ComponentAst comp = this.mockBaseComponentAst();
        Mockito.when((Object)comp.getModel(ParameterizedModel.class)).thenReturn(Optional.of(parameterizedModel));
        Mockito.when((Object)comp.getParameter(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)"myOwnParam"))).thenReturn((Object)parameter);
        MatcherAssert.assertThat(MuleAstUtils.parameterOfType((ComponentAst)comp, (StereotypeModel)myOwnStereotype).get(), (Matcher)CoreMatchers.sameInstance((Object)parameter));
    }

    @Test
    public void parameterOfTypeParentStereotype() {
        ImmutableStereotypeModel myOwnParentStereotype = new ImmutableStereotypeModel("MY_OWN", "MINE", null);
        ImmutableStereotypeModel myOwnStereotype = new ImmutableStereotypeModel("MY_PRECIOUS", "MINE", (StereotypeModel)myOwnParentStereotype);
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel.getAllowedStereotypes()).thenReturn(Collections.singletonList(myOwnStereotype));
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)"myOwnParam");
        ParameterGroupModel groupModel = TestUtils.createMockParameterGroup("General", parameterModel);
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        Mockito.when((Object)parameterizedModel.getParameterGroupModels()).thenReturn(Collections.singletonList(groupModel));
        ComponentParameterAst parameter = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        ComponentAst comp = this.mockBaseComponentAst();
        Mockito.when((Object)comp.getModel(ParameterizedModel.class)).thenReturn(Optional.of(parameterizedModel));
        Mockito.when((Object)comp.getParameter(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)"myOwnParam"))).thenReturn((Object)parameter);
        MatcherAssert.assertThat(MuleAstUtils.parameterOfType((ComponentAst)comp, (StereotypeModel)myOwnParentStereotype).get(), (Matcher)CoreMatchers.sameInstance((Object)parameter));
    }

    @Test
    public void parameterOfTypeNotMatchingStereotype() {
        ImmutableStereotypeModel myOwnStereotype = new ImmutableStereotypeModel("MY_PRECIOUS", "MINE", null);
        ImmutableStereotypeModel myOtherStereotype = new ImmutableStereotypeModel("A_SWORD", "MINE", null);
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel.getAllowedStereotypes()).thenReturn(Collections.singletonList(myOwnStereotype));
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)"myOwnParam");
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        Mockito.when((Object)parameterizedModel.getAllParameterModels()).thenReturn(Collections.singletonList(parameterModel));
        ComponentParameterAst parameter = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        ComponentAst comp = this.mockBaseComponentAst();
        Mockito.when((Object)comp.getModel(ParameterizedModel.class)).thenReturn(Optional.of(parameterizedModel));
        Mockito.when((Object)comp.getParameter(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)"myOwnParam"))).thenReturn((Object)parameter);
        MatcherAssert.assertThat((Object)MuleAstUtils.parameterOfType((ComponentAst)comp, (StereotypeModel)myOtherStereotype).isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void parametersOfTypeSameStereotype() {
        ImmutableStereotypeModel myOwnStereotype = new ImmutableStereotypeModel("MY_OWN", "MINE", null);
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel.getAllowedStereotypes()).thenReturn(Collections.singletonList(myOwnStereotype));
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)"myOwnParam");
        ParameterGroupModel groupModel = TestUtils.createMockParameterGroup("General", parameterModel);
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        Mockito.when((Object)parameterizedModel.getParameterGroupModels()).thenReturn(Collections.singletonList(groupModel));
        ComponentParameterAst parameter = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        ComponentAst comp = this.mockBaseComponentAst();
        Mockito.when((Object)comp.getModel(ParameterizedModel.class)).thenReturn(Optional.of(parameterizedModel));
        Mockito.when((Object)comp.getParameter(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)"myOwnParam"))).thenReturn((Object)parameter);
        MatcherAssert.assertThat((Object)MuleAstUtils.parametersOfType((ComponentAst)comp, (StereotypeModel)myOwnStereotype), (Matcher)IsCollectionContaining.hasItems((Matcher[])new Matcher[]{CoreMatchers.sameInstance((Object)parameter)}));
    }

    @Test
    public void parametersOfTypeSameStereotypeMultiple() {
        ImmutableStereotypeModel myOwnStereotype = new ImmutableStereotypeModel("MY_OWN", "MINE", null);
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel.getAllowedStereotypes()).thenReturn(Collections.singletonList(myOwnStereotype));
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)"myOwnParam");
        ParameterModel parameter2Model = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameter2Model.getAllowedStereotypes()).thenReturn(Collections.singletonList(myOwnStereotype));
        Mockito.when((Object)parameter2Model.getName()).thenReturn((Object)"myOwnParam2");
        ParameterGroupModel groupModel = TestUtils.createMockParameterGroup("General", parameterModel, parameter2Model);
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        Mockito.when((Object)parameterizedModel.getParameterGroupModels()).thenReturn(Collections.singletonList(groupModel));
        ComponentParameterAst parameter = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        ComponentParameterAst parameter2 = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        ComponentAst comp = this.mockBaseComponentAst();
        Mockito.when((Object)comp.getModel(ParameterizedModel.class)).thenReturn(Optional.of(parameterizedModel));
        Mockito.when((Object)comp.getParameter(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)"myOwnParam"))).thenReturn((Object)parameter);
        Mockito.when((Object)comp.getParameter(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)"myOwnParam2"))).thenReturn((Object)parameter2);
        MatcherAssert.assertThat((Object)MuleAstUtils.parametersOfType((ComponentAst)comp, (StereotypeModel)myOwnStereotype), (Matcher)IsCollectionContaining.hasItems((Matcher[])new Matcher[]{CoreMatchers.sameInstance((Object)parameter), CoreMatchers.sameInstance((Object)parameter2)}));
    }

    @Test
    public void parametersOfTypeParentStereotype() {
        ImmutableStereotypeModel myOwnParentStereotype = new ImmutableStereotypeModel("MY_OWN", "MINE", null);
        ImmutableStereotypeModel myOwnStereotype = new ImmutableStereotypeModel("MY_PRECIOUS", "MINE", (StereotypeModel)myOwnParentStereotype);
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel.getAllowedStereotypes()).thenReturn(Collections.singletonList(myOwnStereotype));
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)"myOwnParam");
        ParameterGroupModel groupModel = TestUtils.createMockParameterGroup("General", parameterModel);
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        Mockito.when((Object)parameterizedModel.getParameterGroupModels()).thenReturn(Collections.singletonList(groupModel));
        ComponentParameterAst parameter = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        ComponentAst comp = this.mockBaseComponentAst();
        Mockito.when((Object)comp.getModel(ParameterizedModel.class)).thenReturn(Optional.of(parameterizedModel));
        Mockito.when((Object)comp.getParameter(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)"myOwnParam"))).thenReturn((Object)parameter);
        MatcherAssert.assertThat((Object)MuleAstUtils.parametersOfType((ComponentAst)comp, (StereotypeModel)myOwnParentStereotype), (Matcher)IsCollectionContaining.hasItems((Matcher[])new Matcher[]{CoreMatchers.sameInstance((Object)parameter)}));
    }

    @Test
    public void parametersOfTypeNotMatchingStereotype() {
        ImmutableStereotypeModel myOwnStereotype = new ImmutableStereotypeModel("MY_PRECIOUS", "MINE", null);
        ImmutableStereotypeModel myOtherStereotype = new ImmutableStereotypeModel("A_SWORD", "MINE", null);
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel.getAllowedStereotypes()).thenReturn(Collections.singletonList(myOwnStereotype));
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)"myOwnParam");
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        Mockito.when((Object)parameterizedModel.getAllParameterModels()).thenReturn(Collections.singletonList(parameterModel));
        ComponentParameterAst parameter = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        ComponentAst comp = this.mockBaseComponentAst();
        Mockito.when((Object)comp.getModel(ParameterizedModel.class)).thenReturn(Optional.of(parameterizedModel));
        Mockito.when((Object)comp.getParameter(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)"myOwnParam"))).thenReturn((Object)parameter);
        MatcherAssert.assertThat((Object)MuleAstUtils.parametersOfType((ComponentAst)comp, (StereotypeModel)myOtherStereotype), (Matcher)IsCollectionWithSize.hasSize((int)0));
    }

    private ComponentAst createComponentAst(ComponentAst ... innerComponents) {
        ComponentAst component = this.mockBaseComponentAst();
        Mockito.when((Object)component.directChildrenStream()).thenAnswer(inv -> Stream.of(innerComponents));
        Mockito.when((Object)component.recursiveStream()).thenCallRealMethod();
        Mockito.when((Object)component.recursiveStream((AstTraversalDirection)ArgumentMatchers.any(AstTraversalDirection.class))).thenAnswer(inv -> {
            AstTraversalDirection direction = (AstTraversalDirection)inv.getArgument(0);
            return StreamSupport.stream(component.recursiveSpliterator(direction), false);
        });
        Mockito.when((Object)component.recursiveSpliterator()).thenCallRealMethod();
        Mockito.when((Object)component.recursiveSpliterator((AstTraversalDirection)ArgumentMatchers.any(AstTraversalDirection.class))).thenAnswer(inv -> {
            AstTraversalDirection direction = (AstTraversalDirection)inv.getArgument(0);
            return direction.recursiveSpliterator(component);
        });
        return component;
    }

    @Test
    public void recursiveStreamWithHierarchy() {
        ComponentAst child1110 = this.createComponentAst(new ComponentAst[0]);
        ComponentAst child1111 = this.createComponentAst(new ComponentAst[0]);
        ComponentAst child1112 = this.createComponentAst(new ComponentAst[0]);
        ComponentAst child111 = this.createComponentAst(child1110, child1111, child1112);
        ComponentAst child110 = this.createComponentAst(new ComponentAst[0]);
        ComponentAst child10 = this.createComponentAst(new ComponentAst[0]);
        ComponentAst child11 = this.createComponentAst(child110, child111);
        ComponentAst child1 = this.createComponentAst(child10, child11);
        ComponentAst child22 = this.createComponentAst(new ComponentAst[0]);
        ComponentAst child2 = this.createComponentAst(child22);
        ComponentAst child3 = this.createComponentAst(new ComponentAst[0]);
        ArtifactAst artifact = (ArtifactAst)Mockito.mock(BaseArtifactAst.class);
        Mockito.when((Object)artifact.recursiveStream()).thenAnswer(inv -> Stream.concat(child1.recursiveStream(), child2.recursiveStream()));
        Mockito.when((Object)artifact.topLevelComponentsStream()).thenAnswer(inv -> Stream.of(child1, child2, child3));
        List withHierarchy = MuleAstUtils.recursiveStreamWithHierarchy((ArtifactAst)artifact).collect(Collectors.toList());
        MatcherAssert.assertThat(withHierarchy, (Matcher)IsCollectionWithSize.hasSize((int)11));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(0)).getFirst(), (Matcher)CoreMatchers.sameInstance((Object)child1));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(0)).getSecond(), (Matcher)IsEmptyCollection.empty());
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(1)).getFirst(), (Matcher)CoreMatchers.sameInstance((Object)child10));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(1)).getSecond(), (Matcher)IsCollectionContaining.hasItem((Object)child1));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(2)).getFirst(), (Matcher)CoreMatchers.sameInstance((Object)child11));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(2)).getSecond(), (Matcher)IsCollectionContaining.hasItem((Object)child1));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(3)).getFirst(), (Matcher)CoreMatchers.sameInstance((Object)child110));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(3)).getSecond(), (Matcher)IsCollectionContaining.hasItem((Object)child11));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(4)).getFirst(), (Matcher)CoreMatchers.sameInstance((Object)child111));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(4)).getSecond(), (Matcher)IsCollectionContaining.hasItem((Object)child11));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(5)).getFirst(), (Matcher)CoreMatchers.sameInstance((Object)child1110));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(5)).getSecond(), (Matcher)IsCollectionContaining.hasItem((Object)child111));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(6)).getFirst(), (Matcher)CoreMatchers.sameInstance((Object)child1111));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(6)).getSecond(), (Matcher)IsCollectionContaining.hasItem((Object)child111));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(7)).getFirst(), (Matcher)CoreMatchers.sameInstance((Object)child1112));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(7)).getSecond(), (Matcher)IsCollectionContaining.hasItem((Object)child111));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(8)).getFirst(), (Matcher)CoreMatchers.sameInstance((Object)child2));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(8)).getSecond(), (Matcher)IsEmptyCollection.empty());
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(9)).getFirst(), (Matcher)CoreMatchers.sameInstance((Object)child22));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(9)).getSecond(), (Matcher)IsCollectionContaining.hasItem((Object)child2));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(10)).getFirst(), (Matcher)CoreMatchers.sameInstance((Object)child3));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(10)).getSecond(), (Matcher)IsEmptyCollection.empty());
        withHierarchy = MuleAstUtils.recursiveStreamWithHierarchy((ArtifactAst)artifact, (AstTraversalDirection)AstTraversalDirection.TOP_DOWN).collect(Collectors.toList());
        MatcherAssert.assertThat(withHierarchy, (Matcher)IsCollectionWithSize.hasSize((int)11));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(0)).getFirst(), (Matcher)CoreMatchers.sameInstance((Object)child1));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(0)).getSecond(), (Matcher)IsEmptyCollection.empty());
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(1)).getFirst(), (Matcher)CoreMatchers.sameInstance((Object)child10));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(1)).getSecond(), (Matcher)IsCollectionContaining.hasItem((Object)child1));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(2)).getFirst(), (Matcher)CoreMatchers.sameInstance((Object)child11));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(2)).getSecond(), (Matcher)IsCollectionContaining.hasItem((Object)child1));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(3)).getFirst(), (Matcher)CoreMatchers.sameInstance((Object)child110));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(3)).getSecond(), (Matcher)IsCollectionContaining.hasItem((Object)child11));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(4)).getFirst(), (Matcher)CoreMatchers.sameInstance((Object)child111));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(4)).getSecond(), (Matcher)IsCollectionContaining.hasItem((Object)child11));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(5)).getFirst(), (Matcher)CoreMatchers.sameInstance((Object)child1110));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(5)).getSecond(), (Matcher)IsCollectionContaining.hasItem((Object)child111));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(6)).getFirst(), (Matcher)CoreMatchers.sameInstance((Object)child1111));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(6)).getSecond(), (Matcher)IsCollectionContaining.hasItem((Object)child111));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(7)).getFirst(), (Matcher)CoreMatchers.sameInstance((Object)child1112));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(7)).getSecond(), (Matcher)IsCollectionContaining.hasItem((Object)child111));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(8)).getFirst(), (Matcher)CoreMatchers.sameInstance((Object)child2));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(8)).getSecond(), (Matcher)IsEmptyCollection.empty());
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(9)).getFirst(), (Matcher)CoreMatchers.sameInstance((Object)child22));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(9)).getSecond(), (Matcher)IsCollectionContaining.hasItem((Object)child2));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(10)).getFirst(), (Matcher)CoreMatchers.sameInstance((Object)child3));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(10)).getSecond(), (Matcher)IsEmptyCollection.empty());
        withHierarchy = MuleAstUtils.recursiveStreamWithHierarchy((ArtifactAst)artifact, (AstTraversalDirection)AstTraversalDirection.BOTTOM_UP).collect(Collectors.toList());
        MatcherAssert.assertThat(withHierarchy, (Matcher)IsCollectionWithSize.hasSize((int)11));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(0)).getFirst(), (Matcher)CoreMatchers.sameInstance((Object)child10));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(0)).getSecond(), (Matcher)IsCollectionContaining.hasItem((Object)child1));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(1)).getFirst(), (Matcher)CoreMatchers.sameInstance((Object)child110));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(1)).getSecond(), (Matcher)IsCollectionContaining.hasItem((Object)child11));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(2)).getFirst(), (Matcher)CoreMatchers.sameInstance((Object)child1110));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(2)).getSecond(), (Matcher)IsCollectionContaining.hasItem((Object)child111));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(3)).getFirst(), (Matcher)CoreMatchers.sameInstance((Object)child1111));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(3)).getSecond(), (Matcher)IsCollectionContaining.hasItem((Object)child111));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(4)).getFirst(), (Matcher)CoreMatchers.sameInstance((Object)child1112));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(4)).getSecond(), (Matcher)IsCollectionContaining.hasItem((Object)child111));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(5)).getFirst(), (Matcher)CoreMatchers.sameInstance((Object)child111));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(5)).getSecond(), (Matcher)IsCollectionContaining.hasItem((Object)child11));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(6)).getFirst(), (Matcher)CoreMatchers.sameInstance((Object)child11));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(6)).getSecond(), (Matcher)IsCollectionContaining.hasItem((Object)child1));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(7)).getFirst(), (Matcher)CoreMatchers.sameInstance((Object)child1));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(7)).getSecond(), (Matcher)IsEmptyCollection.empty());
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(8)).getFirst(), (Matcher)CoreMatchers.sameInstance((Object)child22));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(8)).getSecond(), (Matcher)IsCollectionContaining.hasItem((Object)child2));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(9)).getFirst(), (Matcher)CoreMatchers.sameInstance((Object)child2));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(9)).getSecond(), (Matcher)IsEmptyCollection.empty());
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(10)).getFirst(), (Matcher)CoreMatchers.sameInstance((Object)child3));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(10)).getSecond(), (Matcher)IsEmptyCollection.empty());
    }

    @Test
    public void recursiveStreamWithHierarchyWithOrphans() {
        ArtifactAst artifact = (ArtifactAst)Mockito.mock(BaseArtifactAst.class);
        ComponentAst processor = this.createComponentAst(new ComponentAst[0]);
        ComponentAst topLevelComponent = this.createComponentAst(processor);
        ComponentAst orphanProcessor = this.createComponentAst(new ComponentAst[0]);
        Mockito.when((Object)artifact.topLevelComponentsStream()).thenAnswer(inv -> Stream.of(topLevelComponent));
        Mockito.when((Object)artifact.recursiveStream()).thenAnswer(inv -> Stream.of(topLevelComponent, processor, orphanProcessor));
        Mockito.when((Object)artifact.filteredComponents((Predicate)ArgumentMatchers.any())).thenCallRealMethod();
        List withHierarchy = MuleAstUtils.recursiveStreamWithHierarchy((ArtifactAst)artifact).collect(Collectors.toList());
        MatcherAssert.assertThat(withHierarchy, (Matcher)IsCollectionWithSize.hasSize((int)3));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(0)).getFirst(), (Matcher)CoreMatchers.sameInstance((Object)topLevelComponent));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(0)).getSecond(), (Matcher)IsEmptyCollection.empty());
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(1)).getFirst(), (Matcher)CoreMatchers.sameInstance((Object)processor));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(1)).getSecond(), (Matcher)IsCollectionContaining.hasItem((Object)topLevelComponent));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(2)).getFirst(), (Matcher)CoreMatchers.sameInstance((Object)orphanProcessor));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(2)).getSecond(), (Matcher)IsNot.not((Matcher)IsEmptyCollection.empty()));
        withHierarchy = MuleAstUtils.recursiveStreamWithHierarchy((ArtifactAst)artifact, (AstTraversalDirection)AstTraversalDirection.TOP_DOWN).collect(Collectors.toList());
        MatcherAssert.assertThat(withHierarchy, (Matcher)IsCollectionWithSize.hasSize((int)3));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(0)).getFirst(), (Matcher)CoreMatchers.sameInstance((Object)topLevelComponent));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(0)).getSecond(), (Matcher)IsEmptyCollection.empty());
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(1)).getFirst(), (Matcher)CoreMatchers.sameInstance((Object)processor));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(1)).getSecond(), (Matcher)IsCollectionContaining.hasItem((Object)topLevelComponent));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(2)).getFirst(), (Matcher)CoreMatchers.sameInstance((Object)orphanProcessor));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(2)).getSecond(), (Matcher)IsNot.not((Matcher)IsEmptyCollection.empty()));
        withHierarchy = MuleAstUtils.recursiveStreamWithHierarchy((ArtifactAst)artifact, (AstTraversalDirection)AstTraversalDirection.BOTTOM_UP).collect(Collectors.toList());
        MatcherAssert.assertThat(withHierarchy, (Matcher)IsCollectionWithSize.hasSize((int)3));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(0)).getFirst(), (Matcher)CoreMatchers.sameInstance((Object)processor));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(0)).getSecond(), (Matcher)IsCollectionContaining.hasItem((Object)topLevelComponent));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(1)).getFirst(), (Matcher)CoreMatchers.sameInstance((Object)topLevelComponent));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(1)).getSecond(), (Matcher)IsEmptyCollection.empty());
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(2)).getFirst(), (Matcher)CoreMatchers.sameInstance((Object)orphanProcessor));
        MatcherAssert.assertThat((Object)((Pair)withHierarchy.get(2)).getSecond(), (Matcher)IsNot.not((Matcher)IsEmptyCollection.empty()));
    }
}

