/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.internal.DefaultComponentMetadataAst;
import org.mule.runtime.ast.internal.builder.PropertiesResolver;

@Feature(value="Mule Artifact AST")
public class DefaultComponentMetadataAstTestCase {
    @Test
    @Description(value="Checks that the property resolver can be hot-swapped")
    public void whenPropertyResolverIsUpdatedThenAttributesAreResolvedWithTheNewResolver() {
        PropertiesResolver propertiesResolver = new PropertiesResolver();
        propertiesResolver.setMappingFunction(k -> "10");
        ComponentMetadataAst metadataAst = DefaultComponentMetadataAst.builder((PropertiesResolver)propertiesResolver).putDocAttribute("paramWithProperty", "${value}").build();
        MatcherAssert.assertThat(metadataAst.getDocAttributes().get("paramWithProperty"), (Matcher)CoreMatchers.is((Object)"10"));
        propertiesResolver.setMappingFunction(k -> "20");
        MatcherAssert.assertThat(metadataAst.getDocAttributes().get("paramWithProperty"), (Matcher)CoreMatchers.is((Object)"20"));
    }
}

