/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.builder.adapter;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.stereotype.ImmutableStereotypeModel;
import org.mule.runtime.ast.internal.builder.adapter.MetadataTypeModelAdapter;
import org.mule.runtime.ast.internal.model.ExtensionModelHelper;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.declaration.type.annotation.StereotypeTypeAnnotation;
import org.mule.runtime.extension.api.stereotype.StereotypeDefinition;

@Feature(value="Mule Artifact AST")
@Story(value="Parameter AST resolution")
public class MetadataTypeModelAdapterTestCase {
    private ClassTypeLoader typeLoader;
    private ExtensionModelHelper extModelHelper;

    @Before
    public void before() {
        this.typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(MetadataTypeModelAdapterTestCase.class.getClassLoader());
        this.extModelHelper = (ExtensionModelHelper)Mockito.mock(ExtensionModelHelper.class);
    }

    @Test
    public void metadataTypeWithStereotype() {
        MetadataType simplePojoType = (MetadataType)Mockito.spy((Object)this.typeLoader.load(SimplePojo.class));
        StereotypeTypeAnnotation stereotypeTypeAnnotation = StereotypeTypeAnnotation.fromDefinitions(Arrays.asList(SimpleStereotypeDefinition.class));
        stereotypeTypeAnnotation.resolveStereotypes(stCls -> new ImmutableStereotypeModel("SIMPLE", "TEST", null));
        Mockito.when((Object)simplePojoType.getAnnotation(StereotypeTypeAnnotation.class)).thenReturn(Optional.of(stereotypeTypeAnnotation));
        Optional adapter = MetadataTypeModelAdapter.createMetadataTypeModelAdapterWithSterotype((MetadataType)simplePojoType, (ExtensionModelHelper)this.extModelHelper);
        MatcherAssert.assertThat((Object)adapter.isPresent(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void metadataTypeWithoutStereotype() {
        MatcherAssert.assertThat((Object)MetadataTypeModelAdapter.createMetadataTypeModelAdapterWithSterotype((MetadataType)this.typeLoader.load(SimplePojo.class), (ExtensionModelHelper)this.extModelHelper).isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void objectTypeFieldsAsParams() {
        MetadataTypeModelAdapter adapter = MetadataTypeModelAdapter.createParameterizedTypeModelAdapter((MetadataType)this.typeLoader.load(SimplePojo.class), (ExtensionModelHelper)this.extModelHelper);
        MatcherAssert.assertThat((Object)adapter.getAllParameterModels(), (Matcher)IsCollectionWithSize.hasSize((int)2));
        ParameterModel param = (ParameterModel)adapter.getAllParameterModels().get(0);
        MatcherAssert.assertThat((Object)param.getName(), (Matcher)Matchers.is((Object)"pojoSimpleParam"));
        MatcherAssert.assertThat((Object)param.getType(), (Matcher)Matchers.is((Object)this.typeLoader.load(String.class)));
        ParameterModel nameParam = (ParameterModel)adapter.getAllParameterModels().get(1);
        MatcherAssert.assertThat((Object)nameParam.getName(), (Matcher)Matchers.is((Object)"name"));
        MatcherAssert.assertThat((Object)adapter.getParameterGroupModels(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        ParameterGroupModel paramGroup = (ParameterGroupModel)adapter.getParameterGroupModels().get(0);
        MatcherAssert.assertThat((Object)paramGroup.getParameterModels(), (Matcher)IsCollectionWithSize.hasSize((int)2));
        MatcherAssert.assertThat((Object)((ParameterModel)paramGroup.getParameter("pojoSimpleParam").get()).getName(), (Matcher)Matchers.is((Object)"pojoSimpleParam"));
        MatcherAssert.assertThat((Object)paramGroup.isShowInDsl(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)paramGroup.getLayoutModel(), (Matcher)Matchers.is(Optional.empty()));
    }

    public class SimpleStereotypeDefinition
    implements StereotypeDefinition {
        public String getName() {
            return "SIMPLE";
        }

        public String getNamespace() {
            return "TEST";
        }
    }

    public static class SimplePojo {
        @Parameter
        private String pojoSimpleParam;
    }
}

