/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.error;

import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.ast.api.error.ErrorTypeRepositoryProvider;
import org.mule.runtime.ast.internal.error.CompositeErrorTypeRepository;
import org.mule.runtime.ast.internal.error.DefaultErrorTypeRepository;

@Story(value="Error types")
public class CompositeErrorTypeRepositoryTestCase {
    private ErrorTypeRepository errorTypeRepositoryA;
    private final ComponentIdentifier INTERNAL_ERROR = ComponentIdentifier.builder().namespace("NSA").name("NAME").build();
    private final ComponentIdentifier EXPOSED_ERROR = ComponentIdentifier.builder().namespace("NSB").name("OTHER_NAME").build();
    private final ComponentIdentifier OTHER_INTERNAL_ERROR = ComponentIdentifier.builder().namespace("NSB").name("NAME").build();
    private ErrorTypeRepository errorTypeRepositoryB;
    private final ComponentIdentifier ns1error = ComponentIdentifier.builder().namespace("NS1").name("AN_ERROR").build();
    private final ComponentIdentifier ns2error = ComponentIdentifier.builder().namespace("NS2").name("AN_ERROR").build();
    private final ComponentIdentifier ns1internalError = ComponentIdentifier.builder().namespace("NS1").name("AN_INTERNAL_ERROR").build();
    private final ComponentIdentifier ns2internalError = ComponentIdentifier.builder().namespace("NS2").name("AN_INTERNAL_ERROR").build();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() {
        this.errorTypeRepositoryA = new DefaultErrorTypeRepository();
        this.errorTypeRepositoryA.addErrorType(this.EXPOSED_ERROR, ErrorTypeRepositoryProvider.getCoreErrorTypeRepo().getAnyErrorType());
        this.errorTypeRepositoryA.addInternalErrorType(this.INTERNAL_ERROR, ErrorTypeRepositoryProvider.getCoreErrorTypeRepo().getCriticalErrorType());
        this.errorTypeRepositoryA.addInternalErrorType(this.OTHER_INTERNAL_ERROR, ErrorTypeRepositoryProvider.getCoreErrorTypeRepo().getCriticalErrorType());
        this.errorTypeRepositoryB = new DefaultErrorTypeRepository();
        this.errorTypeRepositoryB.addErrorType(this.ns1error, ErrorTypeRepositoryProvider.getCoreErrorTypeRepo().getAnyErrorType());
        this.errorTypeRepositoryB.addErrorType(this.ns2error, ErrorTypeRepositoryProvider.getCoreErrorTypeRepo().getAnyErrorType());
        this.errorTypeRepositoryB.addInternalErrorType(this.ns1internalError, ErrorTypeRepositoryProvider.getCoreErrorTypeRepo().getAnyErrorType());
        this.errorTypeRepositoryB.addInternalErrorType(this.ns2internalError, ErrorTypeRepositoryProvider.getCoreErrorTypeRepo().getAnyErrorType());
    }

    @Test
    public void getErrorNamespaces() {
        CompositeErrorTypeRepository composite = new CompositeErrorTypeRepository(Arrays.asList(this.errorTypeRepositoryA, this.errorTypeRepositoryB));
        MatcherAssert.assertThat((Object)composite.getErrorNamespaces(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"NSA", "NSB", "NS1", "NS2"}));
    }

    @Test
    public void getErrorTypes() {
        CompositeErrorTypeRepository composite = new CompositeErrorTypeRepository(Arrays.asList(this.errorTypeRepositoryA, this.errorTypeRepositoryB));
        Set errorTypeIdentifiers = composite.getErrorTypes().stream().map(err -> ComponentIdentifier.builder().namespace(err.getNamespace()).name(err.getIdentifier()).build()).collect(Collectors.toSet());
        MatcherAssert.assertThat(errorTypeIdentifiers, (Matcher)Matchers.containsInAnyOrder((Object[])new ComponentIdentifier[]{this.EXPOSED_ERROR, this.ns1error, this.ns2error}));
    }

    @Test
    public void getInternalErrorTypes() {
        CompositeErrorTypeRepository composite = new CompositeErrorTypeRepository(Arrays.asList(this.errorTypeRepositoryA, this.errorTypeRepositoryB));
        Set errorTypeIdentifiers = composite.getInternalErrorTypes().stream().map(err -> ComponentIdentifier.builder().namespace(err.getNamespace()).name(err.getIdentifier()).build()).collect(Collectors.toSet());
        MatcherAssert.assertThat(errorTypeIdentifiers, (Matcher)Matchers.containsInAnyOrder((Object[])new ComponentIdentifier[]{this.INTERNAL_ERROR, this.OTHER_INTERNAL_ERROR, this.ns1internalError, this.ns2internalError}));
    }
}

