/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal;

import org.mule.runtime.ast.api.ComponentGenerationInformation;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;

import java.util.Optional;

public class DefaultComponentGenerationInformation implements ComponentGenerationInformation {

  public static Builder builder() {
    return new Builder();
  }

  private final DslElementSyntax syntax;

  public DefaultComponentGenerationInformation(DslElementSyntax syntax) {
    this.syntax = syntax;
  }

  @Override
  public Optional<DslElementSyntax> getSyntax() {
    return Optional.ofNullable(syntax);
  }

  public static class Builder {

    private DslElementSyntax syntax;

    public Builder withSyntax(DslElementSyntax syntax) {
      this.syntax = syntax;
      return this;
    }

    public DslElementSyntax getSyntax() {
      return syntax;
    }

    public ComponentGenerationInformation build() {
      return new DefaultComponentGenerationInformation(syntax);
    }
  }
}
