/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.builder;

import org.mule.runtime.ast.api.NamespaceDefinition;
import org.mule.runtime.ast.api.builder.NamespaceDefinitionBuilder;

import java.util.HashMap;
import java.util.Map;

public class DefaultNamespaceDefinitionBuilder implements NamespaceDefinitionBuilder {

  private Map<String, String> unresolvedNamespaces = new HashMap<>();
  private Map<String, String> schemaLocations = new HashMap<>();
  private String prefix;
  private String namespace;

  @Override
  public NamespaceDefinitionBuilder withNamespace(String namespace) {
    this.namespace = namespace;
    return this;
  }

  @Override
  public NamespaceDefinitionBuilder withPrefix(String prefix) {
    this.prefix = prefix;
    return this;
  }

  @Override
  public NamespaceDefinitionBuilder withSchemaLocation(String schemaLocation, String value) {
    this.schemaLocations.put(schemaLocation, value);
    return this;
  }

  @Override
  public NamespaceDefinitionBuilder withUnresolvedNamespace(String namespace, String schemaLocation) {
    this.unresolvedNamespaces.put(namespace, schemaLocation);
    return this;
  }

  @Override
  public NamespaceDefinition build() {
    return new NamespaceDefinition() {

      @Override
      public Map<String, String> getUnresovedNamespaces() {
        return unresolvedNamespaces;
      }

      @Override
      public Map<String, String> getSchemaLocations() {
        return schemaLocations;
      }

      @Override
      public String getPrefix() {
        return prefix;
      }

      @Override
      public String getNamespace() {
        return namespace;
      }
    };
  }

}
