/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.validation;

import static java.util.Collections.unmodifiableCollection;

import org.mule.runtime.ast.api.validation.ValidationResult;
import org.mule.runtime.ast.api.validation.ValidationResultItem;

import java.util.ArrayList;
import java.util.Collection;

/**
 * Implementation of {@link ValidationResult} that supports adding result items.
 *
 * @since 1.0
 */
public class DefaultValidationResult implements ValidationResult {

  private final Collection<ValidationResultItem> items = new ArrayList<>();

  @Override
  public Collection<ValidationResultItem> getItems() {
    return unmodifiableCollection(items);
  }

  public void addItem(ValidationResultItem item) {
    if (items.stream().noneMatch(i -> i.getValidation().equals(item.getValidation())
        && i.getComponents().containsAll(i.getComponents())
        && i.getParameters().containsAll(i.getParameters()))) {
      items.add(item);
    }
  }

}
