/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.api.util;

import static java.util.Arrays.asList;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;
import static org.mule.runtime.api.meta.model.parameter.ParameterGroupModel.DEFAULT_GROUP_NAME;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;

public class TestUtils {

  public static ParameterGroupModel createMockParameterGroup(String name, ParameterModel... parameterModels) {
    ParameterGroupModel groupModel = mock(ParameterGroupModel.class);
    when(groupModel.getName()).thenReturn(name);
    when(groupModel.getParameterModels()).thenReturn(asList(parameterModels));
    return groupModel;
  }

  public static ParameterGroupModel createMockParameterGroup(ParameterModel... parameterModels) {
    return createMockParameterGroup(DEFAULT_GROUP_NAME, parameterModels);
  }
}
