/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.builder;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.impl.DefaultStringType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.ast.api.ComponentGenerationInformation;
import org.mule.runtime.ast.api.builder.ComponentAstBuilder;
import org.mule.runtime.ast.internal.DefaultComponentParameterAst;
import org.mule.runtime.ast.internal.builder.DefaultComponentAstBuilder;
import org.mule.runtime.ast.internal.builder.PropertiesResolver;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.declaration.type.annotation.LiteralTypeAnnotation;

@Feature(value="Mule Artifact AST")
@Story(value="Parameter AST resolution")
public class ComponentAstParameterTestCase {
    private final ClassTypeLoader TYPE_LOADER = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
    private static final String RAW_VALUE = "rawValue";
    private static final String RAW_VALUE_EXPRESSION = "#[payload]";

    @Description(value="A component parameter with a different raw-value than default model parameter isn't a default parameter")
    @Test
    public void componentParameterWithRawValueIsNonADefaultParameter() {
        ParameterModel model = (ParameterModel)Mockito.mock(ParameterModel.class);
        DefaultComponentParameterAst parameterAst = new DefaultComponentParameterAst(RAW_VALUE, model, null, (ComponentGenerationInformation)Mockito.mock(ComponentGenerationInformation.class), new PropertiesResolver());
        MatcherAssert.assertThat((Object)parameterAst.isDefaultValue(), (Matcher)Matchers.is((Object)false));
    }

    @Description(value="A component parameter without a raw-value is a default parameter")
    @Test
    public void componentParameterWithoutRawValueIsADefaultParameter() {
        ParameterModel model = (ParameterModel)Mockito.mock(ParameterModel.class);
        DefaultComponentParameterAst parameterAst = new DefaultComponentParameterAst((String)null, model, null, (ComponentGenerationInformation)Mockito.mock(ComponentGenerationInformation.class), new PropertiesResolver());
        MatcherAssert.assertThat((Object)parameterAst.isDefaultValue(), (Matcher)Matchers.is((Object)true));
    }

    @Description(value="A component parameter wit same raw-value as a default model parameter is a default parameter")
    @Test
    public void componentParameterWithSameRawValueAsModelDefaultIsADefaultParameter() {
        ParameterModel model = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)model.getDefaultValue()).thenReturn((Object)RAW_VALUE);
        Mockito.when((Object)model.getType()).thenReturn((Object)this.TYPE_LOADER.load(String.class));
        DefaultComponentParameterAst parameterAst = new DefaultComponentParameterAst(RAW_VALUE, model, null, (ComponentGenerationInformation)Mockito.mock(ComponentGenerationInformation.class), new PropertiesResolver());
        MatcherAssert.assertThat((Object)parameterAst.isDefaultValue(), (Matcher)Matchers.is((Object)true));
    }

    @Description(value="A component parameter wit same raw-value expression as a default model parameter is a default parameter")
    @Test
    public void componentParameterWithSameRawValueExpressionAsModelDefaultIsADefaultParameter() {
        ParameterModel model = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)model.getDefaultValue()).thenReturn((Object)RAW_VALUE_EXPRESSION);
        Mockito.when((Object)model.getType()).thenReturn((Object)this.TYPE_LOADER.load(String.class));
        DefaultComponentParameterAst parameterAst = new DefaultComponentParameterAst(RAW_VALUE_EXPRESSION, model, null, (ComponentGenerationInformation)Mockito.mock(ComponentGenerationInformation.class), new PropertiesResolver());
        MatcherAssert.assertThat((Object)parameterAst.isDefaultValue(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)parameterAst.getValue().getLeft(), (Matcher)Matchers.is(parameterAst.extractExpression((Object)RAW_VALUE_EXPRESSION).get()));
    }

    @Description(value="A component parameter with complex value is a default parameter")
    @Test
    public void componentParameterWithComplexValueIsADefaultParameter() {
        ParameterModel model = (ParameterModel)Mockito.mock(ParameterModel.class);
        DefaultComponentAstBuilder child = (DefaultComponentAstBuilder)Mockito.mock(DefaultComponentAstBuilder.class);
        DefaultComponentParameterAst parameterAst = new DefaultComponentParameterAst((ComponentAstBuilder)child, model, null, null, (ComponentGenerationInformation)Mockito.mock(ComponentGenerationInformation.class), new PropertiesResolver());
        MatcherAssert.assertThat((Object)parameterAst.isDefaultValue(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void referencesAsFixedValue() {
        ParameterModel model = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)model.getAllowedStereotypes()).thenReturn(Collections.singletonList(Mockito.mock(StereotypeModel.class)));
        Mockito.when((Object)model.getType()).thenReturn((Object)this.TYPE_LOADER.load(String.class));
        DefaultComponentParameterAst parameterAst = new DefaultComponentParameterAst("aReference", model, null, (ComponentGenerationInformation)Mockito.mock(ComponentGenerationInformation.class), new PropertiesResolver());
        MatcherAssert.assertThat((Object)parameterAst.getValue().isRight(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)parameterAst.getValue().getRight(), (Matcher)Matchers.is((Object)"aReference"));
    }

    @Test
    public void notSupportedExpressionsAsFixedValue() {
        ParameterModel model = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)model.getExpressionSupport()).thenReturn((Object)ExpressionSupport.NOT_SUPPORTED);
        Mockito.when((Object)model.getType()).thenReturn((Object)this.TYPE_LOADER.load(String.class));
        DefaultComponentParameterAst parameterAst = new DefaultComponentParameterAst("#[justMarkers]", model, null, (ComponentGenerationInformation)Mockito.mock(ComponentGenerationInformation.class), new PropertiesResolver());
        MatcherAssert.assertThat((Object)parameterAst.getValue().isRight(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)parameterAst.getValue().getRight(), (Matcher)Matchers.is((Object)"#[justMarkers]"));
    }

    @Test
    public void literalAsFixedValue() {
        MetadataType paramType = (MetadataType)Mockito.spy((Object)this.TYPE_LOADER.load(String.class));
        Mockito.when((Object)paramType.getAnnotation(LiteralTypeAnnotation.class)).thenReturn(Optional.of(new LiteralTypeAnnotation()));
        ParameterModel model = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)model.getExpressionSupport()).thenReturn((Object)ExpressionSupport.SUPPORTED);
        Mockito.when((Object)model.getType()).thenReturn((Object)paramType);
        DefaultComponentParameterAst parameterAst = new DefaultComponentParameterAst("#['hello']", model, null, (ComponentGenerationInformation)Mockito.mock(ComponentGenerationInformation.class), new PropertiesResolver());
        MatcherAssert.assertThat((Object)parameterAst.getValue().isRight(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)parameterAst.getValue().getRight(), (Matcher)Matchers.is((Object)"#['hello']"));
    }

    @Test
    public void fixedValue() {
        ParameterModel model = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)model.getExpressionSupport()).thenReturn((Object)ExpressionSupport.SUPPORTED);
        Mockito.when((Object)model.getType()).thenReturn((Object)this.TYPE_LOADER.load(String.class));
        DefaultComponentParameterAst parameterAst = new DefaultComponentParameterAst("hello", model, null, (ComponentGenerationInformation)Mockito.mock(ComponentGenerationInformation.class), new PropertiesResolver());
        MatcherAssert.assertThat((Object)parameterAst.getValue().isRight(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)parameterAst.getValue().getRight(), (Matcher)Matchers.is((Object)"hello"));
    }

    @Test
    public void expression() {
        ParameterModel model = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)model.getExpressionSupport()).thenReturn((Object)ExpressionSupport.SUPPORTED);
        Mockito.when((Object)model.getType()).thenReturn((Object)this.TYPE_LOADER.load(String.class));
        DefaultComponentParameterAst parameterAst = new DefaultComponentParameterAst("#['hello']", model, null, (ComponentGenerationInformation)Mockito.mock(ComponentGenerationInformation.class), new PropertiesResolver());
        MatcherAssert.assertThat((Object)parameterAst.getValue().isLeft(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)parameterAst.getValue().getLeft(), (Matcher)Matchers.is((Object)"'hello'"));
    }

    @Test
    public void emptyPropertyToNumberWithDefaultValue() {
        ParameterModel model = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)model.getExpressionSupport()).thenReturn((Object)ExpressionSupport.NOT_SUPPORTED);
        Mockito.when((Object)model.getDefaultValue()).thenReturn((Object)"10");
        Mockito.when((Object)model.getType()).thenReturn((Object)this.TYPE_LOADER.load(Integer.class));
        PropertiesResolver propertiesResolver = new PropertiesResolver();
        propertiesResolver.setMappingFunction(k -> null);
        DefaultComponentParameterAst parameterAst = new DefaultComponentParameterAst("${emptyProp}", model, null, (ComponentGenerationInformation)Mockito.mock(ComponentGenerationInformation.class), propertiesResolver);
        MatcherAssert.assertThat((Object)parameterAst.getValue().isRight(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)parameterAst.getValue().getRight(), (Matcher)Matchers.is((Object)10));
    }

    @Test
    @Issue(value="MULE-19074")
    public void primitiveToIntegerWithDefaultValue() {
        this.assertPrimitiveWithDefaultValue(Integer.toString(Integer.MAX_VALUE), Integer.MAX_VALUE, Integer.TYPE);
    }

    @Test
    @Issue(value="MULE-19074")
    public void primitiveToFloatWithDefaultValue() {
        this.assertPrimitiveWithDefaultValue("99.99", Float.valueOf(99.99f), Float.TYPE);
    }

    @Test
    @Issue(value="MULE-19074")
    public void primitiveToLongWithDefaultValue() {
        this.assertPrimitiveWithDefaultValue(Long.toString(Long.MAX_VALUE), Long.MAX_VALUE, Long.TYPE);
    }

    @Test
    @Issue(value="MULE-19074")
    public void primitiveToByteWithDefaultValue() {
        this.assertPrimitiveWithDefaultValue("1", (byte)1, Byte.TYPE);
    }

    @Test
    @Issue(value="MULE-19074")
    public void primitiveToShortWithDefaultValue() {
        this.assertPrimitiveWithDefaultValue("123", (short)123, Short.TYPE);
    }

    @Test
    @Issue(value="MULE-19074")
    public void primitiveToDoubleWithDefaultValue() {
        this.assertPrimitiveWithDefaultValue("99.99", 99.99, Double.TYPE);
    }

    @Test
    public void nullPropertyToNumberWithDefaultValue() {
        ParameterModel model = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)model.getExpressionSupport()).thenReturn((Object)ExpressionSupport.NOT_SUPPORTED);
        Mockito.when((Object)model.getDefaultValue()).thenReturn((Object)10);
        Mockito.when((Object)model.getType()).thenReturn((Object)this.TYPE_LOADER.load(Integer.class));
        PropertiesResolver propertiesResolver = new PropertiesResolver();
        propertiesResolver.setMappingFunction(k -> null);
        DefaultComponentParameterAst parameterAst = new DefaultComponentParameterAst("${emptyProp}", model, null, (ComponentGenerationInformation)Mockito.mock(ComponentGenerationInformation.class), propertiesResolver);
        MatcherAssert.assertThat((Object)parameterAst.getValue().isRight(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)parameterAst.getValue().getRight(), (Matcher)Matchers.is((Object)10));
    }

    @Test
    public void nullPropertyToNumberWithExpressionDefaultValue() {
        ParameterModel model = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)model.getExpressionSupport()).thenReturn((Object)ExpressionSupport.SUPPORTED);
        Mockito.when((Object)model.getDefaultValue()).thenReturn((Object)"#[10]");
        Mockito.when((Object)model.getType()).thenReturn((Object)this.TYPE_LOADER.load(Integer.class));
        PropertiesResolver propertiesResolver = new PropertiesResolver();
        propertiesResolver.setMappingFunction(k -> null);
        DefaultComponentParameterAst parameterAst = new DefaultComponentParameterAst("${emptyProp}", model, null, (ComponentGenerationInformation)Mockito.mock(ComponentGenerationInformation.class), propertiesResolver);
        MatcherAssert.assertThat((Object)parameterAst.getValue().isLeft(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)parameterAst.getValue().getLeft(), (Matcher)Matchers.is((Object)"10"));
    }

    @Test
    public void nullValueToNumberWithDefaultValue() {
        ParameterModel model = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)model.getExpressionSupport()).thenReturn((Object)ExpressionSupport.NOT_SUPPORTED);
        Mockito.when((Object)model.getType()).thenReturn((Object)this.TYPE_LOADER.load(Integer.class));
        DefaultComponentParameterAst parameterAst = new DefaultComponentParameterAst((String)null, model, null, (ComponentGenerationInformation)Mockito.mock(ComponentGenerationInformation.class), new PropertiesResolver());
        MatcherAssert.assertThat((Object)parameterAst.getValue().isLeft(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)parameterAst.getValue().isRight(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void emptyStringNullDefaultNotNull() {
        ParameterModel model = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)model.getExpressionSupport()).thenReturn((Object)ExpressionSupport.SUPPORTED);
        Mockito.when((Object)model.getType()).thenReturn((Object)this.TYPE_LOADER.load(String.class));
        Mockito.when((Object)model.getDefaultValue()).thenReturn(null);
        DefaultComponentParameterAst parameterAst = new DefaultComponentParameterAst("", model, null, (ComponentGenerationInformation)Mockito.mock(ComponentGenerationInformation.class), new PropertiesResolver());
        MatcherAssert.assertThat((Object)parameterAst.getValue().isRight(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)parameterAst.getValue().getRight(), (Matcher)Matchers.is((Object)""));
    }

    @Test
    @Issue(value="MULE-19183")
    @Description(value="A string-type parameter set to \"\" shouldn't be overridden by its default value")
    public void emptyStringOverridesNotNullDefaultValue() {
        ParameterModel model = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)model.getExpressionSupport()).thenReturn((Object)ExpressionSupport.SUPPORTED);
        Mockito.when((Object)model.getType()).thenReturn((Object)this.TYPE_LOADER.load(String.class));
        Mockito.when((Object)model.getDefaultValue()).thenReturn((Object)RAW_VALUE);
        DefaultComponentParameterAst parameterAst = new DefaultComponentParameterAst("", model, null, (ComponentGenerationInformation)Mockito.mock(ComponentGenerationInformation.class), new PropertiesResolver());
        MatcherAssert.assertThat((Object)parameterAst.getValue().isRight(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)parameterAst.getValue().getRight(), (Matcher)Matchers.is((Object)""));
    }

    @Test
    @Issue(value="MULE-19117")
    public void enumValue() {
        DefaultStringType testEnumType = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().with((TypeAnnotation)new EnumAnnotation((Object[])Arrays.stream(TestEnum.values()).map(Enum::name).toArray(String[]::new))).with((TypeAnnotation)new ClassInformationAnnotation(TestEnum.class)).build();
        ParameterModel model = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)model.getExpressionSupport()).thenReturn((Object)ExpressionSupport.NOT_SUPPORTED);
        Mockito.when((Object)model.getType()).thenReturn((Object)testEnumType);
        DefaultComponentParameterAst parameterAst = new DefaultComponentParameterAst(TestEnum.VALUE_B.name(), model, null, (ComponentGenerationInformation)Mockito.mock(ComponentGenerationInformation.class), new PropertiesResolver());
        MatcherAssert.assertThat((Object)parameterAst.getValue().isRight(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)parameterAst.getValue().getRight(), (Matcher)Matchers.is((Object)TestEnum.VALUE_B.name()));
    }

    @Test
    @Issue(value="MULE-19542")
    public void listExpressionWithStereotype() {
        ArrayType arrayType = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).arrayType().of((MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType().build()).build();
        ParameterModel model = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)model.getExpressionSupport()).thenReturn((Object)ExpressionSupport.SUPPORTED);
        Mockito.when((Object)model.getType()).thenReturn((Object)arrayType);
        Mockito.when((Object)model.getAllowedStereotypes()).thenReturn(Collections.singletonList(Mockito.mock(StereotypeModel.class)));
        DefaultComponentParameterAst parameterAst = new DefaultComponentParameterAst("#[[{}, {}]]", model, null, (ComponentGenerationInformation)Mockito.mock(ComponentGenerationInformation.class), new PropertiesResolver());
        MatcherAssert.assertThat((Object)parameterAst.getValue().isLeft(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)parameterAst.getValue().getLeft(), (Matcher)Matchers.is((Object)"[{}, {}]"));
    }

    @Test
    @Issue(value="MULE-19542")
    public void complexExpressionWithStereotype() {
        ObjectType objectType = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType().build();
        ParameterModel model = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)model.getExpressionSupport()).thenReturn((Object)ExpressionSupport.SUPPORTED);
        Mockito.when((Object)model.getType()).thenReturn((Object)objectType);
        Mockito.when((Object)model.getAllowedStereotypes()).thenReturn(Collections.singletonList(Mockito.mock(StereotypeModel.class)));
        DefaultComponentParameterAst parameterAst = new DefaultComponentParameterAst("#[{}]", model, null, (ComponentGenerationInformation)Mockito.mock(ComponentGenerationInformation.class), new PropertiesResolver());
        MatcherAssert.assertThat((Object)parameterAst.getValue().isLeft(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)parameterAst.getValue().getLeft(), (Matcher)Matchers.is((Object)"{}"));
    }

    private void assertPrimitiveWithDefaultValue(String value, Number expected, Class<? extends Number> type) {
        ParameterModel model = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)model.getExpressionSupport()).thenReturn((Object)ExpressionSupport.NOT_SUPPORTED);
        Mockito.when((Object)model.getDefaultValue()).thenReturn((Object)value);
        Mockito.when((Object)model.getType()).thenReturn((Object)this.TYPE_LOADER.load(type));
        PropertiesResolver propertiesResolver = new PropertiesResolver();
        propertiesResolver.setMappingFunction(k -> null);
        DefaultComponentParameterAst parameterAst = new DefaultComponentParameterAst("${emptyProp}", model, null, (ComponentGenerationInformation)Mockito.mock(ComponentGenerationInformation.class), propertiesResolver);
        MatcherAssert.assertThat((Object)parameterAst.getValue().isRight(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)parameterAst.getValue().getRight(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected)));
    }

    public static enum TestEnum {
        VALUE_A,
        VALUE_B;

    }
}

