/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.api.validation;

import org.mule.runtime.ast.api.util.MuleAstUtils;

import java.util.List;
import java.util.function.Supplier;

/**
 * Determines the validations to run for a specific set of components. For instance, each extension may provide their own to
 * provide all validations for that extension.
 * <p>
 * Implementations will be discovered through SPI, using the {@link Thread#getContextClassLoader()} when
 * {@link MuleAstUtils#validate(org.mule.runtime.ast.api.ArtifactAst)} was called.
 * <p>
 * Implementations must be stateless.
 *
 * @since 1.0
 */
public interface ValidationsProvider extends Supplier<List<Validation>> {

}
