/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.model;

import static java.util.Collections.emptyList;
import static java.util.Collections.emptySet;
import static java.util.Optional.empty;

import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.parameter.ExclusiveParametersModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;

import java.util.List;
import java.util.Optional;
import java.util.Set;

public final class RawParameterGroupModel implements ParameterGroupModel {

  @Override
  public Optional<DisplayModel> getDisplayModel() {
    return empty();
  }

  @Override
  public <T extends ModelProperty> Optional<T> getModelProperty(Class<T> propertyType) {
    return empty();
  }

  @Override
  public Set<ModelProperty> getModelProperties() {
    return emptySet();
  }

  @Override
  public String getDescription() {
    return "(owner does not have a set model)";
  }

  @Override
  public String getName() {
    return DEFAULT_GROUP_NAME;
  }

  @Override
  public Optional<LayoutModel> getLayoutModel() {
    return empty();
  }

  @Override
  public List<ExclusiveParametersModel> getExclusiveParametersModels() {
    return emptyList();
  }

  @Override
  public Optional<ParameterModel> getParameter(String name) {
    return empty();
  }

  @Override
  public List<ParameterModel> getParameterModels() {
    return emptyList();
  }

  @Override
  public boolean isShowInDsl() {
    return false;
  }
}
