/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.api;

import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessage;

/**
 * Indicates that the conversion of a fixed parameter value to its expected type failed.
 * 
 * @see ComponentParameterAst#getValue()
 * 
 * @since 1.1
 */
public class ParameterResolutionException extends MuleRuntimeException {

  private static final long serialVersionUID = 1L;

  public ParameterResolutionException(I18nMessage message, Exception cause) {
    super(message, cause);
  }

}
