/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.builder.adapter;

import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.stereotype.HasStereotypeModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.ast.internal.model.ExtensionModelHelper;

class MetadataTypeModelAdapterWithStereotype extends MetadataTypeModelAdapter implements HasStereotypeModel {

  private final StereotypeModel stereotype;

  MetadataTypeModelAdapterWithStereotype(MetadataType type, StereotypeModel stereotype,
                                         ExtensionModelHelper extensionModelHelper) {
    super(type, extensionModelHelper);
    this.stereotype = stereotype;
  }

  @Override
  public StereotypeModel getStereotype() {
    return stereotype;
  }

  @Override
  public String toString() {
    return "MetadataTypeModelAdapterWithStereotype{" + getType().toString() + "}";
  }
}
