/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.ast.api.ComponentGenerationInformation;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.ParameterResolutionException;
import org.mule.runtime.ast.api.builder.ComponentAstBuilder;
import org.mule.runtime.ast.internal.builder.PropertiesResolver;
import org.mule.runtime.extension.api.declaration.type.annotation.LiteralTypeAnnotation;
import org.mule.runtime.extension.api.error.ErrorMapping;

public class DefaultComponentParameterAst
implements ComponentParameterAst {
    private static final String DEFAULT_EXPRESSION_PREFIX = "#[";
    private static final String DEFAULT_EXPRESSION_SUFFIX = "]";
    private static final Class<? extends ModelProperty> allowsExpressionWithoutMarkersModelPropertyClass;
    private static final Map<String, Function<String, Number>> fixedNumberMappings;
    private final String rawValue;
    private final ParameterModel model;
    private final ParameterGroupModel groupModel;
    private final ComponentMetadataAst metadata;
    private final ComponentGenerationInformation generationInformation;
    private volatile LazyValue<String> resolved;
    private volatile LazyValue<Either<String, Object>> value;

    public DefaultComponentParameterAst(String rawValue, ParameterModel model, ParameterGroupModel parameterGroupModel, ComponentGenerationInformation generationInformation, PropertiesResolver propertiesResolver) {
        this(rawValue, model, parameterGroupModel, null, generationInformation, propertiesResolver);
    }

    public DefaultComponentParameterAst(String rawValue, ParameterModel model, ParameterGroupModel parameterGroupModel, ComponentMetadataAst metadata, ComponentGenerationInformation generationInformation, PropertiesResolver propertiesResolver) {
        this(rawValue, rawValue, null, model, parameterGroupModel, metadata, generationInformation, propertiesResolver);
    }

    public DefaultComponentParameterAst(ComponentAstBuilder complexValue, ParameterModel model, ParameterGroupModel parameterGroupModel, ComponentMetadataAst metadata, ComponentGenerationInformation generationInformation, PropertiesResolver propertiesResolver) {
        this(null, null, complexValue::build, model, parameterGroupModel, metadata, generationInformation, propertiesResolver);
    }

    public DefaultComponentParameterAst(List<ComponentAstBuilder> complexValue, ParameterModel model, ParameterGroupModel parameterGroupModel, ComponentMetadataAst metadata, ComponentGenerationInformation generationInformation, PropertiesResolver propertiesResolver) {
        this(null, null, () -> complexValue.stream().map(ComponentAstBuilder::build).collect(Collectors.toList()), model, parameterGroupModel, metadata, generationInformation, propertiesResolver);
    }

    public DefaultComponentParameterAst(List<ErrorMapping> complexValue, ParameterModel model, ParameterGroupModel parameterGroupModel, ComponentGenerationInformation generationInformation, PropertiesResolver propertiesResolver) {
        this(null, null, () -> complexValue, model, parameterGroupModel, null, generationInformation, propertiesResolver);
    }

    private DefaultComponentParameterAst(String rawValue, String mappedRawValue, Supplier<Object> complexValue, ParameterModel model, ParameterGroupModel parameterGroupModel, ComponentMetadataAst metadata, ComponentGenerationInformation generationInformation, PropertiesResolver propertiesResolver) {
        this.rawValue = rawValue;
        this.model = model;
        this.groupModel = parameterGroupModel;
        this.metadata = metadata;
        this.generationInformation = generationInformation;
        this.resetResolvedParam(rawValue, complexValue, propertiesResolver);
        if (complexValue == null && rawValue != null && this.hasPropertyPlaceholder(rawValue)) {
            propertiesResolver.onMappingFunctionChanged(() -> this.resetResolvedParam(rawValue, complexValue, propertiesResolver));
        }
    }

    private void resetResolvedParam(String rawValue, Supplier<Object> complexValue, PropertiesResolver propertiesResolver) {
        if (complexValue != null) {
            this.resolved = new LazyValue();
            this.value = new LazyValue(() -> Either.right(complexValue.get()));
        } else {
            this.resolved = rawValue != null && this.hasPropertyPlaceholder(rawValue) ? new LazyValue(() -> propertiesResolver.apply(rawValue)) : new LazyValue((Object)rawValue);
            this.value = new LazyValue(() -> {
                Object defaultValue;
                String resolvedRawValue = this.getResolvedRawValue();
                if (Objects.isNull(resolvedRawValue) && (defaultValue = this.getModel().getDefaultValue()) != null) {
                    if (defaultValue instanceof String) {
                        resolvedRawValue = (String)defaultValue;
                    } else if (this.getModel().getType().getAnnotation(EnumAnnotation.class).isPresent()) {
                        resolvedRawValue = ((Enum)defaultValue).name();
                    } else {
                        return Either.right((Object)defaultValue);
                    }
                }
                return this.resolveParamValue(resolvedRawValue);
            });
        }
    }

    private Either<String, Object> resolveParamValue(final String resolvedRawValue) {
        final AtomicReference expression = new AtomicReference();
        final AtomicReference fixedValue = new AtomicReference();
        MetadataTypeVisitor visitor = new MetadataTypeVisitor(){

            public void visitObjectField(ObjectFieldType objectFieldType) {
                objectFieldType.getValue().accept((MetadataTypeVisitor)this);
            }

            public void visitBoolean(BooleanType booleanType) {
                this.doVisitPrimitive((MetadataType)booleanType, () -> {
                    if (!StringUtils.isEmpty((CharSequence)resolvedRawValue)) {
                        fixedValue.set(Boolean.valueOf(resolvedRawValue));
                    }
                });
            }

            public void visitNumber(NumberType numberType) {
                this.doVisitPrimitive((MetadataType)numberType, () -> {
                    if (!StringUtils.isEmpty((CharSequence)resolvedRawValue)) {
                        DefaultComponentParameterAst.this.visitFixedNumber(resolvedRawValue, fixedValue, numberType);
                    }
                });
            }

            public void visitString(StringType stringType) {
                this.doVisitPrimitive((MetadataType)stringType, () -> fixedValue.set(resolvedRawValue));
            }

            private void doVisitPrimitive(MetadataType metadataType, Runnable onFixedValue) {
                if (DefaultComponentParameterAst.this.isExpression(resolvedRawValue) || DefaultComponentParameterAst.this.hasPropertyPlaceholder(resolvedRawValue)) {
                    this.defaultVisit(metadataType);
                } else {
                    onFixedValue.run();
                }
            }

            protected void defaultVisit(MetadataType metadataType) {
                if (!DefaultComponentParameterAst.this.getModel().getAllowedStereotypes().isEmpty() && resolvedRawValue != null) {
                    DefaultComponentParameterAst.this.defaultVisitFixedValue(resolvedRawValue, expression, fixedValue);
                } else if (ExpressionSupport.NOT_SUPPORTED.equals((Object)DefaultComponentParameterAst.this.getModel().getExpressionSupport()) || DefaultComponentParameterAst.this.getModel().getType().getAnnotation(LiteralTypeAnnotation.class).isPresent()) {
                    fixedValue.set(resolvedRawValue);
                } else if (!ExpressionSupport.NOT_SUPPORTED.equals((Object)DefaultComponentParameterAst.this.getModel().getExpressionSupport())) {
                    DefaultComponentParameterAst.this.defaultVisitFixedValue(resolvedRawValue, expression, fixedValue);
                } else {
                    Optional<String> extractExpression = DefaultComponentParameterAst.this.extractExpression(resolvedRawValue);
                    if (extractExpression.isPresent()) {
                        expression.set(extractExpression.get());
                    } else {
                        fixedValue.set(resolvedRawValue);
                    }
                }
            }
        };
        try {
            this.getModel().getType().accept(visitor);
        }
        catch (Exception e) {
            throw new ParameterResolutionException(I18nMessageFactory.createStaticMessage((String)String.format("Exception resolving param '%s' with value '%s' at '%s:%d:%d' (%s)", this.getModel().getName(), resolvedRawValue, this.metadata != null ? this.metadata.getFileName().orElse("") : "", this.metadata != null ? this.metadata.getStartLine().orElse(-1) : -1, this.metadata != null ? this.metadata.getStartColumn().orElse(-1) : -1, e.toString())), e);
        }
        if (expression.get() != null) {
            return Either.left(expression.get());
        }
        if (fixedValue.get() != null) {
            return Either.right(fixedValue.get());
        }
        return Either.empty();
    }

    private void visitFixedNumber(String rawValue, AtomicReference<Object> value, NumberType numberType) {
        value.set(numberType.getAnnotation(ClassInformationAnnotation.class).map(classInfo -> fixedNumberMappings.getOrDefault(classInfo.getClassname(), s -> null).apply(rawValue)).orElseGet(() -> {
            try {
                Long longValue = Long.valueOf(rawValue);
                if (longValue <= Integer.MAX_VALUE && longValue >= Integer.MIN_VALUE) {
                    return longValue.intValue();
                }
                return longValue;
            }
            catch (NumberFormatException e) {
                return Double.valueOf(rawValue);
            }
        }));
    }

    private void defaultVisitFixedValue(String rawValue, AtomicReference<String> expression, AtomicReference<Object> fixedValue) {
        Optional<String> expressionOpt = this.extractExpression(rawValue);
        if (expressionOpt.isPresent()) {
            expression.set(expressionOpt.get());
        } else {
            fixedValue.set(rawValue);
        }
    }

    private boolean isExpression(Object value) {
        if (value instanceof String) {
            String trim = ((String)value).trim();
            if (trim.startsWith(DEFAULT_EXPRESSION_PREFIX) && trim.endsWith(DEFAULT_EXPRESSION_SUFFIX)) {
                return true;
            }
            return allowsExpressionWithoutMarkersModelPropertyClass != null && this.getModel().getModelProperty(allowsExpressionWithoutMarkersModelPropertyClass).isPresent();
        }
        return false;
    }

    private boolean hasPropertyPlaceholder(String v) {
        return v != null && v.contains("${");
    }

    public Optional<String> extractExpression(Object value) {
        String expression;
        Optional<String> result = Optional.empty();
        if (this.isExpression(value) && StringUtils.isNotEmpty((CharSequence)(expression = (String)value))) {
            String trimmedText = expression.trim();
            result = trimmedText.startsWith(DEFAULT_EXPRESSION_PREFIX) && trimmedText.endsWith(DEFAULT_EXPRESSION_SUFFIX) ? Optional.of(trimmedText.substring(DEFAULT_EXPRESSION_PREFIX.length(), trimmedText.length() - DEFAULT_EXPRESSION_SUFFIX.length())) : Optional.of(trimmedText);
        }
        return result;
    }

    @Override
    public <T> Either<String, T> getValue() {
        return (Either)this.value.get();
    }

    @Override
    public <T> Either<String, Either<ParameterResolutionException, T>> getValueOrResolutionError() {
        try {
            return this.getValue().mapRight(fixedValue -> Either.right((Object)fixedValue));
        }
        catch (ParameterResolutionException e) {
            return Either.right((Object)Either.left((Object)((Object)e)));
        }
    }

    @Override
    public String getRawValue() {
        return this.rawValue;
    }

    @Override
    public String getResolvedRawValue() {
        return (String)this.resolved.get();
    }

    @Override
    public ParameterModel getModel() {
        return this.model;
    }

    @Override
    public ParameterGroupModel getGroupModel() {
        return this.groupModel;
    }

    @Override
    public Optional<ComponentMetadataAst> getMetadata() {
        return Optional.ofNullable(this.metadata);
    }

    @Override
    public ComponentGenerationInformation getGenerationInformation() {
        return this.generationInformation;
    }

    @Override
    public boolean isDefaultValue() {
        return Optional.ofNullable(this.getResolvedRawValue()).map(v -> {
            if (this.getModel() != null && this.getModel().getDefaultValue() != null) {
                return v.equals(this.getModel().getDefaultValue());
            }
            return false;
        }).orElse(true);
    }

    public String toString() {
        return "DefaultComponentParameterAst{" + this.model.getName() + ": " + this.rawValue + "}";
    }

    static {
        fixedNumberMappings = new HashMap<String, Function<String, Number>>();
        Class<?> foundClass = null;
        try {
            foundClass = Class.forName("org.mule.runtime.module.extension.api.loader.java.property.AllowsExpressionWithoutMarkersModelProperty");
        }
        catch (ClassNotFoundException | SecurityException exception) {
            // empty catch block
        }
        allowsExpressionWithoutMarkersModelPropertyClass = foundClass;
        fixedNumberMappings.put(Integer.class.getName(), Integer::valueOf);
        fixedNumberMappings.put(Integer.TYPE.getName(), Integer::valueOf);
        fixedNumberMappings.put(Float.class.getName(), Float::valueOf);
        fixedNumberMappings.put(Float.TYPE.getName(), Float::valueOf);
        fixedNumberMappings.put(Long.class.getName(), Long::valueOf);
        fixedNumberMappings.put(Long.TYPE.getName(), Long::valueOf);
        fixedNumberMappings.put(Byte.class.getName(), Byte::valueOf);
        fixedNumberMappings.put(Byte.TYPE.getName(), Byte::valueOf);
        fixedNumberMappings.put(Short.class.getName(), Short::valueOf);
        fixedNumberMappings.put(Short.TYPE.getName(), Short::valueOf);
        fixedNumberMappings.put(Double.class.getName(), Double::valueOf);
        fixedNumberMappings.put(Double.TYPE.getName(), Double::valueOf);
    }
}

