/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import org.junit.Test;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.internal.builder.PropertiesResolver;

import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.mule.runtime.ast.AllureConstants.ArtifactAst.ARTIFACT_AST;

@Feature(ARTIFACT_AST)
public class DefaultComponentMetadataAstTestCase {

  @Test
  @Description("Checks that the property resolver can be hot-swapped")
  public void whenPropertyResolverIsUpdatedThenAttributesAreResolvedWithTheNewResolver() {
    final PropertiesResolver propertiesResolver = new PropertiesResolver();
    propertiesResolver.setMappingFunction(k -> "10");

    final ComponentMetadataAst metadataAst = DefaultComponentMetadataAst.builder(propertiesResolver)
        .putDocAttribute("paramWithProperty", "${value}")
        .build();

    // Control test with the original mapping function.
    assertThat(metadataAst.getDocAttributes().get("paramWithProperty"), is("10"));

    // Updates the mapping function and rechecks.
    propertiesResolver.setMappingFunction(k -> "20");
    assertThat(metadataAst.getDocAttributes().get("paramWithProperty"), is("20"));
  }
}
