/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.builder;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.util.NameUtils;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.builder.ComponentAstBuilder;
import org.mule.runtime.ast.internal.DefaultComponentMetadataAst;
import org.mule.runtime.ast.internal.builder.BaseComponentAstBuilder;
import org.mule.runtime.ast.internal.builder.DefaultComponentAstBuilder;
import org.mule.runtime.ast.internal.builder.PropertiesResolver;
import org.mule.runtime.ast.internal.model.ExtensionModelHelper;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;

@Feature(value="Mule Artifact AST")
@Story(value="Parameter AST resolution")
public class ComponentAstParametersTestCase {
    private static final ComponentIdentifier NS_COMP_IDENTIFIER = ComponentIdentifier.builder().namespace("ns").name("comp").build();
    private static final String PARAMETER_A = "a";
    private static final String PARAMETER_B = "b";
    private static final String PARAMETER_C = "c";
    private final ClassTypeLoader TYPE_LOADER = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    private ComponentModel createParameterizedModel() {
        ComponentModel parameterizedModel = (ComponentModel)Mockito.mock(ComponentModel.class);
        ArrayList<ParameterModel> parameterModels = new ArrayList<ParameterModel>();
        parameterModels.add(this.createParameterModel(PARAMETER_A));
        parameterModels.add(this.createParameterModel(PARAMETER_B));
        parameterModels.add(this.createParameterModel(PARAMETER_C));
        Mockito.when((Object)parameterizedModel.getAllParameterModels()).thenReturn(parameterModels);
        ParameterGroupModel paramGroup = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
        Mockito.when((Object)paramGroup.getName()).thenReturn((Object)"General");
        Mockito.when((Object)paramGroup.getParameterModels()).thenReturn(parameterModels);
        Mockito.when((Object)paramGroup.isShowInDsl()).thenReturn((Object)false);
        Mockito.when((Object)parameterizedModel.getParameterGroupModels()).thenReturn(Collections.singletonList(paramGroup));
        return parameterizedModel;
    }

    private ParameterModel createParameterModel(String name) {
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)name);
        Mockito.when((Object)parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(String.class));
        Mockito.when((Object)parameterModel.getRole()).thenReturn((Object)ParameterRole.BEHAVIOUR);
        return parameterModel;
    }

    @Test
    public void retrieveParametersAsDefinedAtExtensionModel() {
        ComponentModel parameterizedModel = this.createParameterizedModel();
        BaseComponentAstBuilder baseComponentModelBuilder = this.baseComponentModelBuilder(new ExtensionModelHelper(Collections.emptySet()), NS_COMP_IDENTIFIER).withParameterizedModel((ParameterizedModel)parameterizedModel);
        parameterizedModel.getAllParameterModels().forEach(p -> baseComponentModelBuilder.withRawParameter(p.getName(), "value-" + p.getName()));
        baseComponentModelBuilder.getGenerationInformation().withSyntax((DslElementSyntax)Mockito.mock(DslElementSyntax.class));
        ComponentAst componentModel = baseComponentModelBuilder.build();
        Collection parameters = componentModel.getParameters();
        MatcherAssert.assertThat((Object)parameters, (Matcher)Matchers.not(Optional.empty()));
        MatcherAssert.assertThat((Object)parameters.size(), (Matcher)Matchers.is((Object)3));
        List expectedParametersName = parameterizedModel.getAllParameterModels().stream().map(NamedObject::getName).collect(Collectors.toList());
        List parametersName = parameters.stream().map(p -> p.getModel().getName()).collect(Collectors.toList());
        MatcherAssert.assertThat(parametersName, (Matcher)Matchers.is(expectedParametersName));
    }

    @Test
    @Issue(value="MULE-18513")
    public void paramsInShowDslGroupProperlyProcessed() {
        ComponentAst withSpaces = this.paramsInShowDslGroupProperlyProcessed("GroupComponent B", "GroupComponent C");
        Collection withSpacesParameters = withSpaces.getParameters();
        MatcherAssert.assertThat(withSpacesParameters.stream().map(p -> p.getValue().getRight()).collect(Collectors.toList()), (Matcher)Matchers.is(Arrays.asList(PARAMETER_A, PARAMETER_B, PARAMETER_C)));
        MatcherAssert.assertThat((Object)withSpacesParameters, (Matcher)IsCollectionWithSize.hasSize((int)3));
        ComponentAst camelCase = this.paramsInShowDslGroupProperlyProcessed("groupB", "groupC");
        Collection camelCaseParameters = camelCase.getParameters();
        MatcherAssert.assertThat(camelCaseParameters.stream().map(p -> p.getValue().getRight()).collect(Collectors.toList()), (Matcher)Matchers.is(Arrays.asList(PARAMETER_A, PARAMETER_B, PARAMETER_C)));
        MatcherAssert.assertThat((Object)camelCaseParameters, (Matcher)IsCollectionWithSize.hasSize((int)3));
        ComponentAst singleWord = this.paramsInShowDslGroupProperlyProcessed("Message", "Advanced");
        Collection singleWordParameters = singleWord.getParameters();
        MatcherAssert.assertThat(singleWordParameters.stream().map(p -> p.getValue().getRight()).collect(Collectors.toList()), (Matcher)Matchers.is(Arrays.asList(PARAMETER_A, PARAMETER_B, PARAMETER_C)));
        MatcherAssert.assertThat((Object)singleWordParameters, (Matcher)IsCollectionWithSize.hasSize((int)3));
    }

    @Test
    @Issue(value="MULE-17711")
    public void showDslGroupNotPresentAsComponentChildren() {
        ComponentAst withSpaces = this.paramsInShowDslGroupProperlyProcessed("GroupComponent B", "GroupComponent C");
        MatcherAssert.assertThat((Object)withSpaces.directChildrenStream().count(), (Matcher)Matchers.is((Object)0L));
        ComponentAst camelCase = this.paramsInShowDslGroupProperlyProcessed("groupB", "groupC");
        MatcherAssert.assertThat((Object)camelCase.directChildrenStream().count(), (Matcher)Matchers.is((Object)0L));
        ComponentAst singleWord = this.paramsInShowDslGroupProperlyProcessed("Message", "Advanced");
        MatcherAssert.assertThat((Object)singleWord.directChildrenStream().count(), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    @Issue(value="MULE-19677")
    public void showDslGroupNotPresentAsComponentChildrenWhenEmpty() {
        ComponentAst groupEmpty = this.paramsInShowDslGroupProperlyProcessed("GroupComponent B", "GroupComponent C", null);
        MatcherAssert.assertThat((Object)groupEmpty.directChildrenStream().count(), (Matcher)Matchers.is((Object)0L));
    }

    private ComponentAst paramsInShowDslGroupProperlyProcessed(String parameterGroupBName, String parameterGroupCName) {
        return this.paramsInShowDslGroupProperlyProcessed(parameterGroupBName, parameterGroupCName, PARAMETER_C);
    }

    private ComponentAst paramsInShowDslGroupProperlyProcessed(String parameterGroupBName, String parameterGroupCName, String paramCValue) {
        OperationModel parameterizedModel = this.createParameterizedModel(parameterGroupBName, parameterGroupCName);
        ExtensionModel extModel = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        ExtensionModelHelper extModelHelper = (ExtensionModelHelper)Mockito.mock(ExtensionModelHelper.class);
        DefaultComponentAstBuilder baseCompBuilder = (DefaultComponentAstBuilder)this.baseComponentModelBuilder(extModelHelper, NS_COMP_IDENTIFIER).withParameterizedModel((ParameterizedModel)parameterizedModel).withExtensionModel(extModel).withRawParameter(PARAMETER_A, PARAMETER_A).withRawParameter(PARAMETER_B, PARAMETER_B);
        String hyphenatedParameterGroupCName = NameUtils.hyphenize((String)parameterGroupCName);
        DslElementSyntax dslElementSyntaxComp = this.createCompDslSyntax(parameterGroupCName, hyphenatedParameterGroupCName);
        baseCompBuilder.getGenerationInformation().withSyntax(dslElementSyntaxComp);
        ComponentAstBuilder paramGroupCChild = baseCompBuilder.addChildComponent().withIdentifier(ComponentIdentifier.buildFromStringRepresentation((String)("test:" + hyphenatedParameterGroupCName))).withMetadata(DefaultComponentMetadataAst.builder().build());
        if (paramCValue != null) {
            paramGroupCChild = paramGroupCChild.withRawParameter(PARAMETER_C, paramCValue);
        }
        ((ExtensionModelHelper)Mockito.doAnswer(inv -> {
            ((ExtensionModelHelper.ExtensionWalkerModelDelegate)inv.getArgument(2, ExtensionModelHelper.ExtensionWalkerModelDelegate.class)).onOperation(parameterizedModel);
            return null;
        }).when((Object)extModelHelper)).walkToComponent((ComponentIdentifier)ArgumentMatchers.eq((Object)NS_COMP_IDENTIFIER), (Optional)ArgumentMatchers.any(), (ExtensionModelHelper.ExtensionWalkerModelDelegate)ArgumentMatchers.any(), (ExtensionModel)ArgumentMatchers.any());
        Mockito.when((Object)extModelHelper.resolveDslElementModel((NamedObject)ArgumentMatchers.eq((Object)parameterizedModel), (ComponentIdentifier)ArgumentMatchers.eq((Object)NS_COMP_IDENTIFIER))).thenReturn((Object)dslElementSyntaxComp);
        Mockito.when((Object)extModelHelper.findComponentType(NS_COMP_IDENTIFIER)).thenReturn((Object)TypedComponentIdentifier.ComponentType.OPERATION);
        return baseCompBuilder.build();
    }

    protected OperationModel createParameterizedModel(String parameterGroupBName, String parameterGroupCName) {
        OperationModel parameterizedModel = (OperationModel)Mockito.mock(OperationModel.class);
        ParameterModel paramA = this.createParameterModel(PARAMETER_A);
        ParameterModel paramB = this.createParameterModel(PARAMETER_B);
        ParameterModel paramC = this.createParameterModel(PARAMETER_C);
        Mockito.when((Object)parameterizedModel.getAllParameterModels()).thenReturn(Arrays.asList(paramA, paramB, paramC));
        ParameterGroupModel paramGroupA = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
        Mockito.when((Object)paramGroupA.getName()).thenReturn((Object)"General");
        Mockito.when((Object)paramGroupA.getParameterModels()).thenReturn(Collections.singletonList(paramA));
        Mockito.when((Object)paramGroupA.isShowInDsl()).thenReturn((Object)false);
        ParameterGroupModel paramGroupB = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
        Mockito.when((Object)paramGroupB.getName()).thenReturn((Object)parameterGroupBName);
        Mockito.when((Object)paramGroupB.getParameterModels()).thenReturn(Collections.singletonList(paramB));
        Mockito.when((Object)paramGroupB.isShowInDsl()).thenReturn((Object)false);
        ParameterGroupModel paramGroupC = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
        Mockito.when((Object)paramGroupC.getName()).thenReturn((Object)parameterGroupCName);
        Mockito.when((Object)paramGroupC.getParameterModels()).thenReturn(Collections.singletonList(paramC));
        Mockito.when((Object)paramGroupC.isShowInDsl()).thenReturn((Object)true);
        Mockito.when((Object)parameterizedModel.getParameterGroupModels()).thenReturn(Arrays.asList(paramGroupA, paramGroupB, paramGroupC));
        return parameterizedModel;
    }

    protected DslElementSyntax createCompDslSyntax(String parameterGroupCName, String hyphenatedParameterGroupCName) {
        DslElementSyntax dslElementSyntaxComp = (DslElementSyntax)Mockito.mock(DslElementSyntax.class);
        DslElementSyntax dslElementSyntaxParameterGroupC = (DslElementSyntax)Mockito.mock(DslElementSyntax.class);
        DslElementSyntax dslElementSyntaxParamC = (DslElementSyntax)Mockito.mock(DslElementSyntax.class);
        Mockito.when((Object)dslElementSyntaxParamC.supportsAttributeDeclaration()).thenReturn((Object)true);
        Mockito.when((Object)dslElementSyntaxParameterGroupC.getElementName()).thenReturn((Object)hyphenatedParameterGroupCName);
        Mockito.when((Object)dslElementSyntaxParameterGroupC.getPrefix()).thenReturn((Object)"test");
        Mockito.when((Object)dslElementSyntaxParameterGroupC.getAttribute(PARAMETER_C)).thenReturn(Optional.of(dslElementSyntaxParamC));
        Mockito.when((Object)dslElementSyntaxComp.getChild(parameterGroupCName)).thenReturn(Optional.of(dslElementSyntaxParameterGroupC));
        return dslElementSyntaxComp;
    }

    private DefaultComponentAstBuilder baseComponentModelBuilder(ExtensionModelHelper helper, ComponentIdentifier compId) {
        return (DefaultComponentAstBuilder)new DefaultComponentAstBuilder(new PropertiesResolver(), helper, Collections.emptyList(), 0).withIdentifier(compId).withMetadata(DefaultComponentMetadataAst.builder().build());
    }
}

