/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.api;

import org.mule.api.annotation.NoImplement;
import org.mule.runtime.ast.internal.DefaultComponentGenerationInformation;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;

import java.util.Optional;

/**
 * Object containing information about the creation of the owning object.
 *
 * @since 1.0
 */
@NoImplement
public interface ComponentGenerationInformation {

  public static final ComponentGenerationInformation EMPTY_GENERATION_INFO =
      DefaultComponentGenerationInformation.builder().build();

  /**
   *
   * @return the information about the XML representation of the owning component, if available.
   */
  Optional<DslElementSyntax> getSyntax();
}
