/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.error;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.containsInAnyOrder;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.is;
import static org.mule.runtime.ast.AllureConstants.ArtifactAst.Errors.ERROR_TYPES;
import static org.mule.runtime.ast.api.error.ErrorTypeRepositoryProvider.getCoreErrorTypeRepo;

import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.message.ErrorType;

import java.util.Collection;
import java.util.Optional;

import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

import io.qameta.allure.Story;

@Story(ERROR_TYPES)
public class DefaultErrorTypeRepositoryTestCase {

  private final ErrorTypeRepository errorTypeRepository = new DefaultErrorTypeRepository();
  private final ComponentIdentifier INTERNAL_ERROR =
      ComponentIdentifier.builder().namespace("NS").name("NAME").build();
  private final ComponentIdentifier EXPOSED_ERROR =
      ComponentIdentifier.builder().namespace("NS2").name("OTHER_NAME").build();
  private final ComponentIdentifier OTHER_INTERNAL_ERROR =
      ComponentIdentifier.builder().namespace("NS2").name("NAME").build();


  @Rule
  public ExpectedException expectedException = ExpectedException.none();

  @Before
  public void setUp() {
    errorTypeRepository.addErrorType(EXPOSED_ERROR, getCoreErrorTypeRepo().getAnyErrorType());
    errorTypeRepository.addInternalErrorType(INTERNAL_ERROR, getCoreErrorTypeRepo().getCriticalErrorType());
    errorTypeRepository.addInternalErrorType(OTHER_INTERNAL_ERROR, getCoreErrorTypeRepo().getCriticalErrorType());
  }

  @Test
  public void doesNotLookupUnavailableErrorType() {
    assertThat(getCoreErrorTypeRepo().lookupErrorType(INTERNAL_ERROR).isPresent(), is(false));
  }

  @Test
  public void getsUnavailableErrorTypes() {
    Optional<ErrorType> myErrorType = errorTypeRepository.getErrorType(INTERNAL_ERROR);
    assertThat(myErrorType.isPresent(), is(true));
    assertThat(myErrorType.get().getIdentifier(), is("NAME"));
    assertThat(myErrorType.get().getParentErrorType(), is(getCoreErrorTypeRepo().getCriticalErrorType()));
  }

  @Test
  public void doesNotAddInternalTypeAsRegularOne() {
    expectedException.expectMessage(is("An error type with identifier 'NS:NAME' already exists"));
    errorTypeRepository.addErrorType(INTERNAL_ERROR, getCoreErrorTypeRepo().getAnyErrorType());
  }

  @Test
  public void returnsUnrepeatedExposedAndInternalNamespaces() {
    Collection<String> errorNamespaces = errorTypeRepository.getErrorNamespaces();
    assertThat(errorNamespaces, hasSize(2));
    assertThat(errorNamespaces, containsInAnyOrder("NS", "NS2"));
  }

  @Test
  public void getErrorTypes() {

  }

  @Test
  public void getInternalErrorTypes() {

  }

}
