/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.api;

import org.mule.api.annotation.NoImplement;

import java.util.Optional;
import java.util.function.UnaryOperator;

/**
 * Represents a resource that can be imported by an artifact.
 */
@NoImplement
public interface ImportedResource {

  public static final String COULD_NOT_RESOLVE_IMPORTED_RESOURCE = "Could not resolve imported resource ";
  public static final String COULD_NOT_FIND_IMPORTED_RESOURCE = "Could not find imported resource ";

  /**
   * This method WILL NOT resolve any property placeholders to the actual values if present. Use {@link #getResourceLocation()} if
   * properties resolution is needed.
   *
   * @return the imported resource file location as defined in the DSL.
   */
  String getRawResourceLocation();

  /**
   * @return the imported resource file location.
   */
  String getResourceLocation();

  /**
   * @return the metadata from the import declaration in the DSL.
   */
  ComponentMetadataAst getMetadata();

  /**
   * @return if the parser was unable to resolve the location for this import, an explanatory message will be returned.
   * @since 1.1
   */
  Optional<String> getResolutionFailure();

  /**
   * Updates the properties resolution callback.
   *
   * @param propertiesResolver The new property resolution callback.
   */
  void updatePropertiesResolver(UnaryOperator<String> propertiesResolver);
}
