/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast;

public interface AllureConstants {

  interface ArtifactAst {

    String ARTIFACT_AST = "Mule Artifact AST";

    interface AstTraversal {

      String AST_TRAVERSAL = "AST traversal";

      String PARAMETER_AST = "Parameter AST resolution";
    }

    interface AstConstruction {

      String ARTIFACT_AST_CONSTRUCTION = "AST construction";

      String NAMESPACE_ARTIFACT_AST_CONSTRUCTION = "Namespace AST Construction";

    }

    interface Errors {

      String ERROR_TYPES = "Error types";

    }

    interface Metadata {

      String ANNOTATIONS = "Annotations";
      String SOURCE_LOCATION = "Source Location";

    }

  }

  interface OperationExecutionFeature {

    String OPERATION_EXECUTION_FEATURE = "Mule Framework Operation Execution";

    interface Stories {

      String EXECUTE_OPERATION = "Execute operation";
    }
  }

  interface DietToolingFeature {

    String DIET_TOOLING = "Diet Tooling";

    interface Stories {

      String TEST_CONNECTIVITY = "Test Connectivity";
      String METADATA_TYPES_RESOLUTION = "Metadata types resolution";
      String VALUE_PROVIDER = "Value Provider Resolution";
      String SAMPLE_DATA = "Sample Data Resolution";
    }
  }
}
