/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.model;

import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsMapContaining;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.impl.DefaultObjectType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.SubTypesModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.ast.internal.model.ExtensionModelHelper;

public class ExtensionModelHelperTestCase {
    private ExtensionModel extensionModel;
    private ExtensionModelHelper extensionModelHelper;
    private ComponentIdentifier nestableAndConstructId;
    private ComponentIdentifier nestableFromOperationAndSourceId;
    private ComponentIdentifier parentIdentifier;
    private ComponentIdentifier operationId;
    private ComponentIdentifier sourceId;
    private ExtensionModelHelper.ExtensionWalkerModelDelegate delegate;
    private OperationModel operationModel;
    private SourceModel sourceModel;
    private NestableElementModel nestableThatIsAlsoAConstructElementModel;
    private NestableElementModel nestableFromOperation;
    private NestableElementModel nestableFromSource;
    private ConstructModel constructModel;

    @Before
    public void setup() {
        this.extensionModel = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        Mockito.when((Object)this.extensionModel.getName()).thenReturn((Object)"SomeTestExtensionName");
        this.nestableAndConstructId = (ComponentIdentifier)Mockito.mock(ComponentIdentifier.class);
        Mockito.when((Object)this.nestableAndConstructId.getName()).thenReturn((Object)"nestable-that-is-also-a-construct");
        this.nestableFromOperationAndSourceId = (ComponentIdentifier)Mockito.mock(ComponentIdentifier.class);
        Mockito.when((Object)this.nestableFromOperationAndSourceId.getName()).thenReturn((Object)"nestable-from-operation-and-source");
        this.delegate = (ExtensionModelHelper.ExtensionWalkerModelDelegate)Mockito.spy((Object)Mockito.mock(ExtensionModelHelper.ExtensionWalkerModelDelegate.class));
        this.parentIdentifier = (ComponentIdentifier)Mockito.mock(ComponentIdentifier.class);
        Mockito.when((Object)this.parentIdentifier.getName()).thenReturn((Object)"parent-of-nestable");
        this.operationId = (ComponentIdentifier)Mockito.mock(ComponentIdentifier.class);
        Mockito.when((Object)this.operationId.getName()).thenReturn((Object)"some-operation-name");
        this.operationModel = (OperationModel)Mockito.mock(OperationModel.class);
        Mockito.when((Object)this.operationModel.getName()).thenReturn((Object)"SomeOperationName");
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Collections.singletonList(this.operationModel));
        this.sourceId = (ComponentIdentifier)Mockito.mock(ComponentIdentifier.class);
        Mockito.when((Object)this.sourceId.getName()).thenReturn((Object)"some-source-name");
        this.sourceModel = (SourceModel)Mockito.mock(SourceModel.class);
        Mockito.when((Object)this.sourceModel.getName()).thenReturn((Object)"SomeSourceName");
        Mockito.when((Object)this.extensionModel.getSourceModels()).thenReturn(Collections.singletonList(this.sourceModel));
        XmlDslModel xmlDslModel = XmlDslModel.builder().setNamespace("ns").setPrefix("prefix").build();
        Mockito.when((Object)this.extensionModel.getXmlDslModel()).thenReturn((Object)xmlDslModel);
        this.nestableThatIsAlsoAConstructElementModel = (NestableElementModel)Mockito.mock(NestableElementModel.class);
        this.nestableFromOperation = (NestableElementModel)Mockito.mock(NestableElementModel.class);
        this.nestableFromSource = (NestableElementModel)Mockito.mock(NestableElementModel.class);
        Mockito.when((Object)this.nestableFromOperation.getName()).thenReturn((Object)"NestableFromOperationAndSource");
        Mockito.when((Object)this.nestableFromSource.getName()).thenReturn((Object)"NestableFromOperationAndSource");
        List<NestableElementModel> operationNestedComponents = Arrays.asList(this.nestableThatIsAlsoAConstructElementModel, this.nestableFromOperation);
        List<NestableElementModel> sourceNestedComponents = Collections.singletonList(this.nestableFromSource);
        Mockito.when((Object)this.nestableThatIsAlsoAConstructElementModel.getName()).thenReturn((Object)"NestableThatIsAlsoAConstruct");
        Mockito.when((Object)this.operationModel.getNestedComponents()).thenReturn(operationNestedComponents);
        Mockito.when((Object)this.sourceModel.getNestedComponents()).thenReturn(sourceNestedComponents);
        this.constructModel = (ConstructModel)Mockito.mock(ConstructModel.class);
        Mockito.when((Object)this.constructModel.getName()).thenReturn((Object)"NestableThatIsAlsoAConstruct");
        Mockito.when((Object)this.extensionModel.getConstructModel((String)ArgumentMatchers.eq((Object)"NestableThatIsAlsoAConstruct"))).thenReturn(Optional.of(this.constructModel));
        Mockito.when((Object)this.extensionModel.getConstructModels()).thenReturn(Collections.singletonList(this.constructModel));
    }

    @Test
    @Issue(value="MULE-19570")
    @Description(value="When a nestable and a construct have the same name, the onConstruct is called and the onNestableElement is not")
    public void whenANestableAndAConstructHaveTheSameNameTheOnConstructIsCalledAndTheOnNestableElementIsNot() {
        this.extensionModelHelper = new ExtensionModelHelper(Collections.singleton(this.extensionModel));
        this.extensionModelHelper.walkToComponent(this.nestableAndConstructId, Optional.of(this.parentIdentifier), this.delegate, this.extensionModel);
        ((ExtensionModelHelper.ExtensionWalkerModelDelegate)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.never())).onNestableElement((NestableElementModel)ArgumentMatchers.eq((Object)this.nestableThatIsAlsoAConstructElementModel));
        ((ExtensionModelHelper.ExtensionWalkerModelDelegate)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.times((int)1))).onConstruct((ConstructModel)ArgumentMatchers.eq((Object)this.constructModel));
    }

    @Test
    @Issue(value="W-10920842")
    public void nonInstantiableTypesFilteredFromSubTypes() {
        HashSet<SubTypesModel> subTypes = new HashSet<SubTypesModel>();
        DefaultObjectType superInterface = this.createObjectType(false, "SuperInterface");
        DefaultObjectType subType = this.createObjectType(true, "SubType");
        subTypes.add(new SubTypesModel((MetadataType)superInterface, Collections.singleton(subType)));
        Mockito.when((Object)this.extensionModel.getSubTypes()).thenReturn(subTypes);
        Mockito.when((Object)this.extensionModel.getTypes()).thenReturn(new HashSet<DefaultObjectType>(Arrays.asList(superInterface, subType)));
        this.extensionModelHelper = new ExtensionModelHelper(Collections.singleton(this.extensionModel));
        Map resolvedSubTypes = this.extensionModelHelper.resolveSubTypes((ObjectType)superInterface);
        MatcherAssert.assertThat((Object)resolvedSubTypes, (Matcher)IsMapContaining.hasKey((Object)subType));
        MatcherAssert.assertThat((Object)resolvedSubTypes, (Matcher)Matchers.not((Matcher)IsMapContaining.hasKey((Object)superInterface)));
    }

    @Test
    @Issue(value="W-11292607")
    public void nestableFromOperationAndSource() {
        this.extensionModelHelper = new ExtensionModelHelper(Collections.singleton(this.extensionModel));
        this.extensionModelHelper.walkToComponent(this.nestableFromOperationAndSourceId, Optional.of(this.operationId), this.delegate, this.extensionModel);
        ((ExtensionModelHelper.ExtensionWalkerModelDelegate)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.never())).onNestableElement((NestableElementModel)ArgumentMatchers.eq((Object)this.nestableFromSource));
        ((ExtensionModelHelper.ExtensionWalkerModelDelegate)Mockito.verify((Object)this.delegate)).onNestableElement((NestableElementModel)ArgumentMatchers.eq((Object)this.nestableFromOperation));
        Mockito.reset((Object[])new ExtensionModelHelper.ExtensionWalkerModelDelegate[]{this.delegate});
        this.extensionModelHelper.walkToComponent(this.nestableFromOperationAndSourceId, Optional.of(this.sourceId), this.delegate, this.extensionModel);
        ((ExtensionModelHelper.ExtensionWalkerModelDelegate)Mockito.verify((Object)this.delegate)).onNestableElement((NestableElementModel)ArgumentMatchers.eq((Object)this.nestableFromSource));
        ((ExtensionModelHelper.ExtensionWalkerModelDelegate)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.never())).onNestableElement((NestableElementModel)ArgumentMatchers.eq((Object)this.nestableFromOperation));
    }

    protected DefaultObjectType createObjectType(boolean isInstantiable, String className) {
        HashMap<Class, Object> extensions = new HashMap<Class, Object>();
        extensions.put(TypeIdAnnotation.class, new TypeIdAnnotation(className));
        extensions.put(ClassInformationAnnotation.class, new ClassInformationAnnotation(className, false, false, isInstantiable, false, false, Collections.emptyList(), null, Collections.emptyList(), false));
        return new DefaultObjectType(Collections.emptySet(), false, null, null, extensions);
    }
}

