/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentGenerationInformation;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.BaseComponentAst;
import org.mule.runtime.ast.internal.builder.PropertiesResolver;

public final class DefaultComponentAst
extends BaseComponentAst {
    private final List<ComponentAst> directChildren;
    private final LoadingCache<Pair<String, String>, Optional<ComponentParameterAst>> paramResolutionCache;
    private volatile Supplier<Optional<String>> componentId;
    private volatile LazyValue<Collection<ComponentParameterAst>> allParams;
    private final Map<String, Object> annotations;
    private final ExtensionModel extensionModel;
    private final ComponentModel componentModel;
    private final NestableElementModel nestableElementModel;
    private final ConfigurationModel configurationModel;
    private final ConnectionProviderModel connectionProviderModel;
    private final ParameterizedModel parameterizedModel;
    private final MetadataType type;
    private final ComponentGenerationInformation generationInformation;
    private final ComponentMetadataAst metadata;
    private final ComponentLocation location;
    private final ComponentIdentifier identifier;
    private final TypedComponentIdentifier.ComponentType componentType;

    public DefaultComponentAst(List<ComponentAst> builtChildren, Map<Pair<ParameterModel, ParameterGroupModel>, ComponentParameterAst> parameterAsts, Map<String, String> extraParams, PropertiesResolver propertiesResolver, Map<String, Object> annotations, Supplier<Optional<String>> componentId, ExtensionModel extensionModel, ComponentModel componentModel, NestableElementModel nestableElementModel, ConfigurationModel configurationModel, ConnectionProviderModel connectionProviderModel, ParameterizedModel parameterizedModel, MetadataType type, ComponentGenerationInformation generationInformation, ComponentMetadataAst metadata, ComponentLocation location, ComponentIdentifier identifier, TypedComponentIdentifier.ComponentType componentType) {
        this.directChildren = builtChildren;
        this.paramResolutionCache = this.initParametersCache();
        this.allParams = this.initAllParams(parameterAsts);
        this.resetComponentId(propertiesResolver, componentId);
        propertiesResolver.onMappingFunctionChanged(() -> this.resetComponentId(propertiesResolver, componentId));
        this.annotations = Collections.unmodifiableMap(annotations);
        this.extensionModel = extensionModel;
        this.componentModel = componentModel;
        this.nestableElementModel = nestableElementModel;
        this.configurationModel = configurationModel;
        this.connectionProviderModel = connectionProviderModel;
        this.parameterizedModel = parameterizedModel;
        this.type = type;
        this.generationInformation = generationInformation;
        this.metadata = metadata;
        this.location = location;
        this.identifier = identifier;
        this.componentType = componentType;
    }

    private @NonNull LoadingCache<Pair<String, String>, Optional<ComponentParameterAst>> initParametersCache() {
        return Caffeine.newBuilder().build(key -> Optional.ofNullable(this.doGetParameter(this.getParameters(), (String)key.getFirst(), (String)key.getSecond())));
    }

    private void resetComponentId(PropertiesResolver propertiesResolver, Supplier<Optional<String>> componentId) {
        if (this.componentId == null || this.componentId instanceof LazyValue && ((LazyValue)this.componentId).isComputed()) {
            this.componentId = new LazyValue(() -> ((Optional)componentId.get()).map(propertiesResolver));
        }
    }

    private LazyValue<Collection<ComponentParameterAst>> initAllParams(Map<Pair<ParameterModel, ParameterGroupModel>, ComponentParameterAst> parameterAsts) {
        return new LazyValue(() -> {
            if (!this.getModel(ParameterizedModel.class).isPresent()) {
                String id = this.getExtensionModel() != null ? this.getExtensionModel().getName() + ":" + this.toString() : "(no_ext)" + this.toString();
                throw new IllegalStateException("Model for '" + id + "' (a '" + this.getModel(NamedObject.class).map(NamedObject::getName) + ")' is not parameterizable.");
            }
            return new ArrayList(parameterAsts.values());
        });
    }

    @Override
    public List<ComponentAst> directChildren() {
        return this.directChildren;
    }

    @Override
    public ComponentParameterAst getParameter(String groupName, String paramName) {
        return ((Optional)this.paramResolutionCache.get((Object)new Pair((Object)groupName, (Object)paramName))).orElse(null);
    }

    @Override
    public Collection<ComponentParameterAst> getParameters() {
        return (Collection)this.allParams.get();
    }

    @Override
    public ExtensionModel getExtensionModel() {
        return this.extensionModel;
    }

    @Override
    public <M> Optional<M> getModel(Class<M> modelClass) {
        if (modelClass.isInstance(this.componentModel)) {
            return Optional.of(modelClass.cast(this.componentModel));
        }
        if (modelClass.isInstance(this.configurationModel)) {
            return Optional.of(modelClass.cast(this.configurationModel));
        }
        if (modelClass.isInstance(this.connectionProviderModel)) {
            return Optional.of(modelClass.cast(this.connectionProviderModel));
        }
        if (modelClass.isInstance(this.nestableElementModel)) {
            return Optional.of(modelClass.cast(this.nestableElementModel));
        }
        if (modelClass.isInstance(this.parameterizedModel)) {
            return Optional.of(modelClass.cast(this.parameterizedModel));
        }
        return Optional.empty();
    }

    @Override
    public MetadataType getType() {
        return this.type;
    }

    @Override
    public ComponentGenerationInformation getGenerationInformation() {
        return this.generationInformation;
    }

    @Override
    public Map<String, Object> getAnnotations() {
        return this.annotations;
    }

    @Override
    public ComponentMetadataAst getMetadata() {
        return this.metadata;
    }

    @Override
    public ComponentLocation getLocation() {
        return this.location;
    }

    @Override
    public ComponentIdentifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public TypedComponentIdentifier.ComponentType getComponentType() {
        return this.componentType;
    }

    @Override
    public Optional<String> getComponentId() {
        return this.componentId.get();
    }
}

