/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.error;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.error.ErrorModelBuilder;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.error.ErrorTypeRepositoryProvider;
import org.mule.runtime.extension.api.error.ErrorMapping;
import org.mule.runtime.extension.internal.property.NoErrorMappingModelProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorTypeRepositoryBuildingUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorTypeRepositoryBuildingUtils.class);
    public static final String CORE_ERROR_NS = "mule".toUpperCase();
    public static final String RETRY_EXHAUSTED_ERROR_IDENTIFIER = "RETRY_EXHAUSTED";
    public static final String CONNECTIVITY_ERROR_IDENTIFIER = "CONNECTIVITY";
    public static final String RAISE_ERROR = "raise-error";
    public static final String ERROR_TYPE_PARAM = "type";
    public static final ComponentIdentifier RETRY_EXHAUSTED = ComponentIdentifier.builder().namespace(CORE_ERROR_NS).name("RETRY_EXHAUSTED").build();
    public static final ComponentIdentifier CONNECTIVITY = ComponentIdentifier.builder().namespace(CORE_ERROR_NS).name("CONNECTIVITY").build();
    public static final ComponentIdentifier RAISE_ERROR_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("raise-error").build();

    public static void addErrorsFromExtensions(Set<ExtensionModel> extensionModels, ErrorTypeRepository errorTypeRepository) {
        extensionModels.stream().filter(em -> !em.getName().equals("mule")).forEach(extensionModel -> ErrorTypeRepositoryBuildingUtils.addErrorsFromExtension(errorTypeRepository, extensionModel));
    }

    private static void addErrorsFromExtension(final ErrorTypeRepository errorTypeRepository, final ExtensionModel extensionModel) {
        LOGGER.debug("Registering errorTypes from extension '{}'...", (Object)extensionModel.getName());
        final Set errorTypes = extensionModel.getErrorModels();
        String extensionNamespace = extensionModel.getXmlDslModel().getPrefix();
        String errorExtensionNamespace = extensionNamespace.toUpperCase();
        errorTypes.forEach(errorModel -> ErrorTypeRepositoryBuildingUtils.getErrorType(errorTypeRepository, errorModel, extensionModel));
        final ErrorModel connectivityErrorModel = ErrorModelBuilder.newError((String)CONNECTIVITY_ERROR_IDENTIFIER, (String)errorExtensionNamespace).withParent(ErrorModelBuilder.newError((ComponentIdentifier)CONNECTIVITY).build()).build();
        final ErrorModel retryExhaustedError = ErrorModelBuilder.newError((String)RETRY_EXHAUSTED_ERROR_IDENTIFIER, (String)errorExtensionNamespace).withParent(ErrorModelBuilder.newError((ComponentIdentifier)RETRY_EXHAUSTED).build()).build();
        IdempotentExtensionWalker extensionWalker = new IdempotentExtensionWalker(){

            protected void onSource(SourceModel model) {
                this.registerErrors((ComponentModel)model);
                this.stop();
            }

            protected void onOperation(OperationModel model) {
                this.registerErrors((ComponentModel)model);
                this.stop();
            }

            protected void onConstruct(ConstructModel model) {
                this.registerErrors((ComponentModel)model);
                this.stop();
            }

            private void registerErrors(ComponentModel model) {
                if (!errorTypes.isEmpty()) {
                    ErrorTypeRepositoryBuildingUtils.getErrorType(errorTypeRepository, connectivityErrorModel, extensionModel);
                    ErrorTypeRepositoryBuildingUtils.getErrorType(errorTypeRepository, retryExhaustedError, extensionModel);
                }
            }
        };
        extensionWalker.walk(extensionModel);
    }

    public static void addErrorsFromArtifact(ArtifactAst artifact, ErrorTypeRepository errorTypeRepository) {
        artifact.topLevelComponentsStream().forEach(componentModel -> ErrorTypeRepositoryBuildingUtils.resolveErrorTypes(errorTypeRepository, componentModel));
    }

    private static void resolveErrorTypes(ErrorTypeRepository errorTypeRepository, ComponentAst componentModel) {
        componentModel.directChildrenStream().filter(innerComponent -> componentModel.getMetadata().getFileName().flatMap(fileName -> innerComponent.getMetadata().getFileName().map(fileName::equals)).orElse(false)).forEach(innerComponent -> {
            ErrorTypeRepositoryBuildingUtils.processRaiseError(errorTypeRepository, innerComponent);
            ErrorTypeRepositoryBuildingUtils.resolveErrorTypes(errorTypeRepository, innerComponent);
        });
        ErrorTypeRepositoryBuildingUtils.registerErrorMappings(errorTypeRepository, componentModel);
    }

    private static void registerErrorMappings(ErrorTypeRepository errorTypeRepository, ComponentAst componentModel) {
        ErrorTypeRepositoryBuildingUtils.forEachErrorMappingDo(componentModel, mappings -> mappings.forEach(mapping -> ErrorTypeRepositoryBuildingUtils.resolveErrorType(errorTypeRepository, mapping.getTarget())));
    }

    private static void resolveErrorType(ErrorTypeRepository errorTypeRepository, String representation) {
        if (StringUtils.isEmpty((CharSequence)representation)) {
            return;
        }
        ComponentIdentifier errorIdentifier = ErrorTypeRepositoryBuildingUtils.parserErrorType(representation);
        String namespace = errorIdentifier.getNamespace();
        if (CORE_ERROR_NS.equals(namespace)) {
            return;
        }
        Optional optionalErrorType = errorTypeRepository.lookupErrorType(errorIdentifier);
        if (optionalErrorType.isPresent()) {
            return;
        }
        LOGGER.debug("Registering errorType '{}'", (Object)errorIdentifier);
        errorTypeRepository.addErrorType(errorIdentifier, ErrorTypeRepositoryProvider.getCoreErrorTypeRepo().getAnyErrorType());
    }

    private static ComponentIdentifier parserErrorType(String representation) {
        String identifier;
        String namespace;
        int separator = representation.indexOf(58);
        if (separator > 0) {
            namespace = representation.substring(0, separator).toUpperCase();
            identifier = representation.substring(separator + 1).toUpperCase();
        } else {
            namespace = CORE_ERROR_NS;
            identifier = representation.toUpperCase();
        }
        return ErrorTypeRepositoryBuildingUtils.createIdentifier(identifier, namespace);
    }

    private static void forEachErrorMappingDo(ComponentAst operation, Consumer<List<ErrorMapping>> action) {
        operation.getModel(OperationModel.class).ifPresent(opModel -> {
            ComponentParameterAst errorMappingsParam;
            if (!opModel.getModelProperty(NoErrorMappingModelProperty.class).isPresent() && (errorMappingsParam = operation.getParameter("Error Mappings", "errorMappings")) != null) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Registering errorTypes from operation error-mapping's @ '{}'...", (Object)operation.getLocation().getLocation());
                }
                errorMappingsParam.getValue().applyRight(action);
            }
        });
    }

    private static void processRaiseError(ErrorTypeRepository errorTypeRepository, ComponentAst componentModel) {
        if (componentModel.getIdentifier().equals(RAISE_ERROR_IDENTIFIER)) {
            ComponentParameterAst parameter;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Registering errorType from raise-error @ '{}'...", (Object)componentModel.getLocation().getLocation());
            }
            if ((parameter = componentModel.getParameter("General", ERROR_TYPE_PARAM)) != null) {
                parameter.getValue().getValue().map(r -> (String)r).ifPresent(representation -> ErrorTypeRepositoryBuildingUtils.resolveErrorType(errorTypeRepository, representation));
            }
        }
    }

    private static ErrorType getErrorType(ErrorTypeRepository errorTypeRepository, ErrorModel errorModel, ExtensionModel extensionModel) {
        ComponentIdentifier identifier = ErrorTypeRepositoryBuildingUtils.createIdentifier(errorModel.getType(), errorModel.getNamespace());
        Optional optionalError = errorTypeRepository.getErrorType(identifier);
        return optionalError.orElseGet(() -> ErrorTypeRepositoryProvider.getCoreErrorTypeRepo().getErrorType(identifier).orElseGet(() -> ErrorTypeRepositoryBuildingUtils.createErrorType(errorTypeRepository, errorModel, identifier, extensionModel)));
    }

    private static ComponentIdentifier createIdentifier(String name, String namespace) {
        return ComponentIdentifier.builder().name(name).namespace(namespace).build();
    }

    private static ErrorType createErrorType(ErrorTypeRepository errorTypeRepository, ErrorModel errorModel, ComponentIdentifier identifier, ExtensionModel extensionModel) {
        if (identifier.getNamespace().equals(CORE_ERROR_NS)) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("The extension [%s] tried to register the [%s] error with [%s] namespace, which is not allowed.", extensionModel.getName(), identifier, CORE_ERROR_NS)));
        }
        LOGGER.debug("Registering errorType '{}'", (Object)identifier);
        Optional optionalErrorModel = errorModel.getParent();
        ErrorType errorType = optionalErrorModel.isPresent() ? errorTypeRepository.addErrorType(identifier, ErrorTypeRepositoryBuildingUtils.getErrorType(errorTypeRepository, (ErrorModel)optionalErrorModel.get(), extensionModel)) : errorTypeRepository.addErrorType(identifier, null);
        return errorType;
    }
}

