/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.api.builder;

import org.mule.api.annotation.NoImplement;
import org.mule.runtime.ast.api.NamespaceDefinition;
import org.mule.runtime.ast.internal.builder.DefaultNamespaceDefinitionBuilder;

/**
 * Provides a way of creating {@link NamespaceDefinition} instances, adding and configuring its components.
 *
 * @since 1.0
 */
@NoImplement
public interface NamespaceDefinitionBuilder {

  static NamespaceDefinitionBuilder builder() {
    return new DefaultNamespaceDefinitionBuilder();
  }

  /**
   * Sets the namespace name of the {@link NamespaceDefinition} being built
   * 
   * @param namespace
   * @return this builder
   */
  NamespaceDefinitionBuilder withNamespace(String namespace);

  /**
   * Sets the prefix of the {@link NamespaceDefinition} being built
   * 
   * @param prefix
   * @return this builder
   */
  NamespaceDefinitionBuilder withPrefix(String prefix);

  /**
   * Sets one schema location to the {@link NamespaceDefinition} being built
   * 
   * @param schemaLocation
   * @param location
   * @return this builder
   */
  NamespaceDefinitionBuilder withSchemaLocation(String schemaLocation, String location);

  /**
   * Sets one namespace that was not resolved
   * 
   * @param namespace
   * @param schemaLocation
   * @return this builder
   */
  NamespaceDefinitionBuilder withUnresolvedNamespace(String namespace, String schemaLocation);

  /**
   * @return the built {@link NamespaceDefinition}
   */
  NamespaceDefinition build();
}
