/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.test.internal.builder;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.HashSet;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.collection.IsEmptyCollection;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.DependencyResolutionMode;
import org.mule.runtime.ast.api.builder.ArtifactAstBuilder;

@Feature(value="Mule Artifact AST")
@Story(value="AST construction")
public class DefaultArtifactAstBuilderTestCase {
    private String previousDependencyResolutionModeValue;
    private ExtensionModel extModelA;
    private ExtensionModel extModelB;

    @Before
    public void before() {
        XmlDslModel xmlDslModelA = XmlDslModel.builder().setNamespace("http://ns.test/extA").setPrefix("extA").build();
        this.extModelA = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        Mockito.when((Object)this.extModelA.getName()).thenReturn((Object)"extA");
        Mockito.when((Object)this.extModelA.getXmlDslModel()).thenReturn((Object)xmlDslModelA);
        XmlDslModel xmlDslModelB = XmlDslModel.builder().setNamespace("http://ns.test/extB").setPrefix("extB").build();
        this.extModelB = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        Mockito.when((Object)this.extModelB.getName()).thenReturn((Object)"extB");
        Mockito.when((Object)this.extModelB.getXmlDslModel()).thenReturn((Object)xmlDslModelB);
        this.previousDependencyResolutionModeValue = System.getProperty("mule." + DependencyResolutionMode.class.getName());
        System.setProperty("mule." + DependencyResolutionMode.class.getName(), DependencyResolutionMode.MINIMAL.name());
    }

    @After
    public void after() {
        if (this.previousDependencyResolutionModeValue != null) {
            System.setProperty("mule." + DependencyResolutionMode.class.getName(), this.previousDependencyResolutionModeValue);
        } else {
            System.clearProperty("mule." + DependencyResolutionMode.class.getName());
        }
    }

    @Test
    public void extensionsDependencyResolutionNoDependencies() {
        ArtifactAstBuilder builder = ArtifactAstBuilder.builder(new HashSet<ExtensionModel>(Arrays.asList(this.extModelA, this.extModelB)), null);
        ArtifactAst artifactAst = builder.build();
        MatcherAssert.assertThat((Object)artifactAst.dependencies(), (Matcher)IsEmptyCollection.empty());
    }

    @Test
    public void extensionsDependencyResolutionJustOneDependency() {
        ArtifactAstBuilder builder = ArtifactAstBuilder.builder(new HashSet<ExtensionModel>(Arrays.asList(this.extModelA, this.extModelB)), null);
        builder.addTopLevelComponent().withIdentifier(ComponentIdentifier.builder().namespace("extA").namespaceUri("http://ns.test/extA").name("component").build()).withParameterizedModel((ParameterizedModel)Mockito.mock(ParameterizedModel.class)).withMetadata((ComponentMetadataAst)Mockito.mock(ComponentMetadataAst.class));
        ArtifactAst artifactAst = builder.build();
        MatcherAssert.assertThat((Object)artifactAst.dependencies(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)((ExtensionModel)artifactAst.dependencies().iterator().next()).getName(), (Matcher)Matchers.is((Object)"extA"));
    }
}

