/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.test.internal.builder.adapter;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.metadata.api.annotation.DefaultValueAnnotation;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectKeyType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.parameter.ExclusiveParametersModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.ast.internal.builder.adapter.MetadataTypeModelAdapter;
import org.mule.runtime.ast.internal.model.ExtensionModelHelper;
import org.mule.runtime.extension.api.declaration.type.annotation.ExclusiveOptionalsTypeAnnotation;
import org.mule.runtime.extension.api.util.NameUtils;

@Feature(value="Mule Artifact AST")
@Story(value="Parameter AST resolution")
public class ObjectTypeAsParameterGroupAdapterTestCase {
    private static final String OBJECT_FIELD_A = "A";
    private static final String OBJECT_FIELD_B = "B";
    private static final String OBJECT_FIELD_C = "C";
    private ObjectType type;
    private ExtensionModelHelper extensionModelHelper;

    @Before
    public void setup() {
        this.type = this.createObjectType();
        this.extensionModelHelper = (ExtensionModelHelper)Mockito.mock(ExtensionModelHelper.class);
    }

    @Test
    public void getParametersSortedByName() {
        MetadataTypeModelAdapter metadataTypeModelAdapter = MetadataTypeModelAdapter.createParameterizedTypeModelAdapter((MetadataType)this.type, (ExtensionModelHelper)this.extensionModelHelper);
        List parameterGroupModels = metadataTypeModelAdapter.getParameterGroupModels();
        MatcherAssert.assertThat((Object)parameterGroupModels, (Matcher)Matchers.not(Optional.empty()));
        MatcherAssert.assertThat((Object)parameterGroupModels.size(), (Matcher)Matchers.is((Object)1));
        List parameterModels = ((ParameterGroupModel)parameterGroupModels.get(0)).getParameterModels();
        MatcherAssert.assertThat((Object)parameterModels, (Matcher)Matchers.not(Optional.empty()));
        MatcherAssert.assertThat((Object)parameterModels.size(), (Matcher)Matchers.is((Object)4));
        List parameters = parameterModels.stream().map(NamedObject::getName).collect(Collectors.toList());
        MatcherAssert.assertThat(parameters, (Matcher)Matchers.is(Arrays.asList(OBJECT_FIELD_A, OBJECT_FIELD_B, OBJECT_FIELD_C, "name")));
    }

    @Test
    @Issue(value="MULE-19349")
    public void exclusiveParametersModel() {
        MetadataTypeModelAdapter metadataTypeModelAdapter = MetadataTypeModelAdapter.createParameterizedTypeModelAdapter((MetadataType)this.type, (ExtensionModelHelper)this.extensionModelHelper);
        ParameterGroupModel parameterGroupModel = (ParameterGroupModel)metadataTypeModelAdapter.getParameterGroupModels().get(0);
        MatcherAssert.assertThat((Object)parameterGroupModel.getExclusiveParametersModels().size(), (Matcher)Matchers.is((Object)2));
        ExclusiveParametersModel bExclusive = (ExclusiveParametersModel)parameterGroupModel.getExclusiveParametersModels().get(0);
        MatcherAssert.assertThat((Object)bExclusive.isOneRequired(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)bExclusive.getExclusiveParameterNames(), (Matcher)Matchers.contains((Object[])new String[]{"exclusiveJ", "exclusiveK"}));
        ExclusiveParametersModel aExclusive = (ExclusiveParametersModel)parameterGroupModel.getExclusiveParametersModels().get(1);
        MatcherAssert.assertThat((Object)aExclusive.isOneRequired(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)aExclusive.getExclusiveParameterNames(), (Matcher)Matchers.contains((Object[])new String[]{"exclusiveX", "exclusiveY"}));
    }

    @Test
    @Issue(value="MULE-19649")
    public void typeWithNoAlias() {
        MetadataTypeModelAdapter metadataTypeModelAdapter = MetadataTypeModelAdapter.createParameterizedTypeModelAdapter((MetadataType)this.type, (ExtensionModelHelper)this.extensionModelHelper);
        ParameterGroupModel parameterGroupModel = (ParameterGroupModel)metadataTypeModelAdapter.getParameterGroupModels().get(0);
        Assert.assertThrows(IllegalArgumentException.class, () -> NameUtils.getAliasName((MetadataType)this.type));
        MatcherAssert.assertThat((Object)parameterGroupModel.getName(), (Matcher)Matchers.is((Object)"General"));
    }

    @Test
    @Issue(value="W-12438526")
    public void fieldWithDefaultValue() {
        MetadataTypeModelAdapter metadataTypeModelAdapter = MetadataTypeModelAdapter.createParameterizedTypeModelAdapter((MetadataType)this.type, (ExtensionModelHelper)this.extensionModelHelper);
        ParameterGroupModel parameterGroupModel = (ParameterGroupModel)metadataTypeModelAdapter.getParameterGroupModels().get(0);
        MatcherAssert.assertThat((Object)((ParameterModel)parameterGroupModel.getParameter(OBJECT_FIELD_C).get()).getDefaultValue(), (Matcher)Matchers.is((Object)"42"));
    }

    private ObjectType createObjectType() {
        ObjectType objectType = (ObjectType)Mockito.mock(ObjectType.class);
        HashSet<ObjectFieldType> fields = new HashSet<ObjectFieldType>();
        fields.add(this.createObjectFieldType(OBJECT_FIELD_C));
        fields.add(this.createObjectFieldTypeWithExclusiveness(OBJECT_FIELD_B, false, "exclusiveX", "exclusiveY"));
        fields.add(this.createObjectFieldTypeWithExclusiveness(OBJECT_FIELD_A, true, "exclusiveJ", "exclusiveK"));
        Mockito.when((Object)objectType.getFields()).thenReturn(fields);
        return objectType;
    }

    private ObjectFieldType createObjectFieldType(String name) {
        QName qName = (QName)Mockito.mock(QName.class);
        Mockito.when((Object)qName.getLocalPart()).thenReturn((Object)name);
        ObjectKeyType objectKeyType = (ObjectKeyType)Mockito.mock(ObjectKeyType.class);
        Mockito.when((Object)objectKeyType.getName()).thenReturn((Object)qName);
        ObjectFieldType objectFieldType = (ObjectFieldType)Mockito.mock(ObjectFieldType.class);
        Mockito.when((Object)objectFieldType.getKey()).thenReturn((Object)objectKeyType);
        NumberType numberFieldValue = (NumberType)Mockito.mock(NumberType.class);
        Mockito.when((Object)numberFieldValue.getAnnotation(DefaultValueAnnotation.class)).thenReturn(Optional.of(new DefaultValueAnnotation("42")));
        Mockito.when((Object)objectFieldType.getValue()).thenReturn((Object)numberFieldValue);
        return objectFieldType;
    }

    private ObjectFieldType createObjectFieldTypeWithExclusiveness(String name, boolean oneRequired, String ... exclusiveParamNames) {
        QName qName = (QName)Mockito.mock(QName.class);
        Mockito.when((Object)qName.getLocalPart()).thenReturn((Object)name);
        ObjectKeyType objectKeyType = (ObjectKeyType)Mockito.mock(ObjectKeyType.class);
        Mockito.when((Object)objectKeyType.getName()).thenReturn((Object)qName);
        ObjectFieldType objectFieldType = (ObjectFieldType)Mockito.mock(ObjectFieldType.class);
        Mockito.when((Object)objectFieldType.getKey()).thenReturn((Object)objectKeyType);
        Mockito.when((Object)objectFieldType.getAnnotation(ExclusiveOptionalsTypeAnnotation.class)).thenReturn(Optional.of(new ExclusiveOptionalsTypeAnnotation(new HashSet<String>(Arrays.asList(exclusiveParamNames)), oneRequired)));
        return objectFieldType;
    }
}

