/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.test.internal.error;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.ast.api.error.ErrorTypeRepositoryProvider;
import org.mule.runtime.ast.internal.error.ErrorTypeBuilder;

public class TestErrorTypeRepositoryProvider
implements ErrorTypeRepositoryProvider,
ErrorTypeRepository {
    public static final String ANY_IDENTIFIER = "ANY";
    public static final String CRITICAL_IDENTIFIER = "CRITICAL";
    public static final String SOURCE_ERROR_IDENTIFIER = "SOURCE";
    public static final String SOURCE_RESPONSE_ERROR_IDENTIFIER = "SOURCE_RESPONSE";
    private static final ErrorType ANY_ERROR_TYPE = ErrorTypeBuilder.builder().namespace("mule".toUpperCase()).identifier("ANY").build();
    private static final ErrorType SOURCE_ERROR_TYPE = ErrorTypeBuilder.builder().namespace("mule".toUpperCase()).identifier("SOURCE").parentErrorType(ANY_ERROR_TYPE).build();
    private static final ErrorType SOURCE_RESPONSE_ERROR_TYPE = ErrorTypeBuilder.builder().namespace("mule".toUpperCase()).identifier("SOURCE_RESPONSE").parentErrorType(SOURCE_ERROR_TYPE).build();
    public static final ErrorType CRITICAL_ERROR_TYPE = ErrorTypeBuilder.builder().namespace("mule".toUpperCase()).identifier("CRITICAL").parentErrorType(null).build();

    public ErrorTypeRepository get() {
        return this;
    }

    public Collection<String> getErrorNamespaces() {
        return Collections.singleton("mule".toUpperCase());
    }

    public ErrorType getAnyErrorType() {
        return ANY_ERROR_TYPE;
    }

    public ErrorType getSourceErrorType() {
        return SOURCE_ERROR_TYPE;
    }

    public ErrorType getSourceResponseErrorType() {
        return SOURCE_RESPONSE_ERROR_TYPE;
    }

    public ErrorType getCriticalErrorType() {
        return CRITICAL_ERROR_TYPE;
    }

    public ErrorType addErrorType(ComponentIdentifier errorTypeIdentifier, ErrorType parentErrorType) {
        throw new UnsupportedOperationException();
    }

    public ErrorType addInternalErrorType(ComponentIdentifier errorTypeIdentifier, ErrorType parentErrorType) {
        throw new UnsupportedOperationException();
    }

    public Optional<ErrorType> lookupErrorType(ComponentIdentifier errorTypeComponentIdentifier) {
        if (errorTypeComponentIdentifier.getNamespace().equals("mule".toUpperCase())) {
            return Optional.of(ErrorTypeBuilder.builder().namespace(errorTypeComponentIdentifier.getNamespace()).identifier(errorTypeComponentIdentifier.getName()).parentErrorType(ANY_ERROR_TYPE).build());
        }
        return Optional.empty();
    }

    public Optional<ErrorType> getErrorType(ComponentIdentifier errorTypeIdentifier) {
        if (errorTypeIdentifier.getNamespace().equals("mule".toUpperCase()) && !errorTypeIdentifier.getName().equals("CUSTOM")) {
            return Optional.of(ErrorTypeBuilder.builder().namespace(errorTypeIdentifier.getNamespace()).identifier(errorTypeIdentifier.getName()).parentErrorType(ANY_ERROR_TYPE).build());
        }
        return Optional.empty();
    }

    public Set<ErrorType> getErrorTypes() {
        return Collections.emptySet();
    }

    public Set<ErrorType> getInternalErrorTypes() {
        return Collections.emptySet();
    }
}

