/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.test.api.util;

import io.qameta.allure.Issue;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.AstTraversalDirection;
import org.mule.runtime.ast.api.util.BaseArtifactAst;
import org.mule.runtime.ast.api.util.BaseComponentAst;
import org.mule.runtime.ast.api.util.BaseComponentAstDecorator;
import org.mule.runtime.ast.api.util.MuleArtifactAstCopyUtils;

public class MuleArtifactAstCopyUtilsTestCase {
    private ArtifactAst artifact;
    private ComponentAst processor;
    private ComponentAst topLevelComponent;
    private ComponentAst randomComponent;
    private ComponentAst withParamComponent;
    private ComponentAst complexParamValue;

    @Before
    public void after() {
        this.processor = (ComponentAst)Mockito.mock(BaseComponentAst.class);
        Mockito.when((Object)this.processor.directChildren()).thenAnswer(inv -> Collections.emptyList());
        Mockito.when((Object)this.processor.directChildrenStream()).thenAnswer(inv -> Stream.empty());
        Mockito.when((Object)this.processor.recursiveStream()).thenCallRealMethod();
        Mockito.when((Object)this.processor.recursiveStream((AstTraversalDirection)ArgumentMatchers.any(AstTraversalDirection.class))).thenAnswer(inv -> Stream.of(this.processor));
        this.topLevelComponent = (ComponentAst)Mockito.mock(BaseComponentAst.class);
        Mockito.when((Object)this.topLevelComponent.directChildren()).thenAnswer(inv -> Collections.singletonList(this.processor));
        Mockito.when((Object)this.topLevelComponent.directChildrenStream()).thenAnswer(inv -> Stream.of(this.processor));
        Mockito.when((Object)this.topLevelComponent.recursiveStream()).thenCallRealMethod();
        Mockito.when((Object)this.topLevelComponent.recursiveStream((AstTraversalDirection)ArgumentMatchers.any(AstTraversalDirection.class))).thenAnswer(inv -> Stream.of(this.topLevelComponent, this.processor));
        this.randomComponent = (ComponentAst)Mockito.mock(BaseComponentAst.class);
        Mockito.when((Object)this.randomComponent.directChildren()).thenAnswer(inv -> Collections.emptyList());
        Mockito.when((Object)this.randomComponent.directChildrenStream()).thenAnswer(inv -> Stream.empty());
        Mockito.when((Object)this.randomComponent.recursiveStream()).thenCallRealMethod();
        Mockito.when((Object)this.randomComponent.recursiveStream((AstTraversalDirection)ArgumentMatchers.any(AstTraversalDirection.class))).thenAnswer(inv -> Stream.of(this.randomComponent));
        this.artifact = (ArtifactAst)Mockito.mock(BaseArtifactAst.class);
        Mockito.when((Object)this.artifact.recursiveStream()).thenCallRealMethod();
        Mockito.when((Object)this.artifact.topLevelComponentsStream()).thenAnswer(inv -> Stream.of(this.topLevelComponent));
        Mockito.when((Object)this.artifact.recursiveStream((AstTraversalDirection)ArgumentMatchers.any(AstTraversalDirection.class))).thenAnswer(inv -> this.artifact.topLevelComponentsStream().flatMap(c -> c.recursiveStream((AstTraversalDirection)inv.getArgument(0))));
        this.withParamComponent = (ComponentAst)Mockito.mock(BaseComponentAst.class);
        Mockito.when((Object)this.withParamComponent.getModel(ParameterizedModel.class)).thenReturn(Optional.of((ParameterizedModel)Mockito.mock(ParameterizedModel.class)));
        Mockito.when((Object)this.withParamComponent.directChildren()).thenAnswer(inv -> Collections.singletonList(this.processor));
        Mockito.when((Object)this.withParamComponent.directChildrenStream()).thenAnswer(inv -> Stream.of(this.processor));
        Mockito.when((Object)this.withParamComponent.recursiveStream()).thenCallRealMethod();
        Mockito.when((Object)this.withParamComponent.recursiveStream((AstTraversalDirection)ArgumentMatchers.any(AstTraversalDirection.class))).thenAnswer(inv -> Stream.of(this.withParamComponent, this.processor));
        this.complexParamValue = (ComponentAst)Mockito.mock(BaseComponentAst.class);
        ObjectType objectType = (ObjectType)Mockito.mock(ObjectType.class);
        ((ObjectType)Mockito.doAnswer(inv -> {
            ((MetadataTypeVisitor)inv.getArgument(0, MetadataTypeVisitor.class)).visitObject(objectType);
            return null;
        }).when((Object)objectType)).accept((MetadataTypeVisitor)ArgumentMatchers.any());
        ParameterModel complexParamModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)complexParamModel.getName()).thenReturn((Object)"complexParam");
        Mockito.when((Object)complexParamModel.getType()).thenReturn((Object)objectType);
        ComponentParameterAst complexParam = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)complexParam.getValue()).thenReturn((Object)Either.right((Object)this.complexParamValue));
        Mockito.when((Object)complexParam.getModel()).thenReturn((Object)complexParamModel);
        Mockito.when((Object)this.withParamComponent.getParameters()).thenReturn(Collections.singletonList(complexParam));
    }

    @Test
    public void copyComponentIdentityMap() {
        ComponentAst copy = MuleArtifactAstCopyUtils.copyComponentTreeRecursively((ComponentAst)this.topLevelComponent, UnaryOperator.identity());
        MatcherAssert.assertThat((Object)copy, (Matcher)CoreMatchers.sameInstance((Object)this.topLevelComponent));
    }

    @Test
    public void copyComponentMapChild() {
        ComponentAst copy = MuleArtifactAstCopyUtils.copyComponentTreeRecursively((ComponentAst)this.topLevelComponent, c -> {
            if (c == this.processor) {
                return new BaseComponentAstDecorator((ComponentAst)c){};
            }
            return c;
        });
        MatcherAssert.assertThat((Object)copy, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)this.topLevelComponent)));
        MatcherAssert.assertThat((Object)((ComponentAst)copy.directChildrenStream().findFirst().get()), (Matcher)CoreMatchers.instanceOf(BaseComponentAstDecorator.class));
    }

    @Test
    public void copyComponentMapParent() {
        ComponentAst copy = MuleArtifactAstCopyUtils.copyComponentTreeRecursively((ComponentAst)this.topLevelComponent, c -> {
            if (c == this.topLevelComponent) {
                return new BaseComponentAstDecorator((ComponentAst)c){};
            }
            return c;
        });
        MatcherAssert.assertThat((Object)copy, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)this.topLevelComponent)));
        MatcherAssert.assertThat((Object)((ComponentAst)copy.directChildrenStream().findFirst().get()), (Matcher)CoreMatchers.sameInstance((Object)this.processor));
    }

    @Test
    public void copyComponentHierarchy() {
        AtomicReference mappedParent = new AtomicReference();
        AtomicReference mappedChild = new AtomicReference();
        ComponentAst copy = MuleArtifactAstCopyUtils.copyComponentTreeRecursively((ComponentAst)this.topLevelComponent, c -> {
            if (c == this.processor) {
                BaseComponentAstDecorator baseComponentAstDecorator = new BaseComponentAstDecorator((ComponentAst)c){};
                mappedChild.set(baseComponentAstDecorator);
                return baseComponentAstDecorator;
            }
            BaseComponentAstDecorator baseComponentAstDecorator = new BaseComponentAstDecorator((ComponentAst)c){};
            mappedParent.set(baseComponentAstDecorator);
            return baseComponentAstDecorator;
        });
        MatcherAssert.assertThat(copy.recursiveStream().collect(Collectors.toList()), (Matcher)CoreMatchers.equalTo(Arrays.asList((ComponentAst)mappedParent.get(), (ComponentAst)mappedChild.get())));
    }

    @Test
    public void addComponentToArtifact() {
        ArtifactAst copy = MuleArtifactAstCopyUtils.copyRecursively((ArtifactAst)this.artifact, UnaryOperator.identity(), () -> Collections.singletonList(this.randomComponent), c -> false);
        MatcherAssert.assertThat(copy.recursiveStream().collect(Collectors.toList()), (Matcher)CoreMatchers.equalTo(Arrays.asList(this.topLevelComponent, this.processor, this.randomComponent)));
        MatcherAssert.assertThat(copy.topLevelComponentsStream().collect(Collectors.toList()), (Matcher)CoreMatchers.equalTo(Arrays.asList(this.topLevelComponent, this.randomComponent)));
    }

    @Test
    public void removeComponentToArtifact() {
        ArtifactAst copyMoreTopLevel = MuleArtifactAstCopyUtils.copyRecursively((ArtifactAst)this.artifact, UnaryOperator.identity(), () -> Collections.singletonList(this.randomComponent), c -> false);
        ArtifactAst copy = MuleArtifactAstCopyUtils.copyRecursively((ArtifactAst)copyMoreTopLevel, UnaryOperator.identity(), () -> Collections.emptyList(), c -> c == this.topLevelComponent);
        MatcherAssert.assertThat(copy.topLevelComponentsStream().collect(Collectors.toList()), (Matcher)CoreMatchers.equalTo(Arrays.asList(this.randomComponent)));
        MatcherAssert.assertThat(copy.recursiveStream().collect(Collectors.toList()), (Matcher)CoreMatchers.equalTo(Arrays.asList(this.randomComponent)));
    }

    @Test
    @Issue(value="MULE-19572")
    public void complexParamMapped() {
        ComponentAst copy = MuleArtifactAstCopyUtils.copyComponentTreeRecursively((ComponentAst)this.withParamComponent, c -> {
            if (c == this.complexParamValue) {
                return new BaseComponentAstDecorator((ComponentAst)c){};
            }
            return c;
        });
        ComponentParameterAst complexParamCopy = (ComponentParameterAst)copy.getParameters().iterator().next();
        MatcherAssert.assertThat((Object)complexParamCopy.getValue().getRight(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)this.complexParamValue)));
        MatcherAssert.assertThat((Object)complexParamCopy.getValue().getRight(), (Matcher)CoreMatchers.instanceOf(BaseComponentAstDecorator.class));
    }

    @Test
    @Issue(value="W-14626100")
    public void complexParameterMappedTwiceShouldReturnSameAst() {
        BaseComponentAstDecorator expected = new BaseComponentAstDecorator(this.complexParamValue){};
        ComponentAst firstCopy = MuleArtifactAstCopyUtils.copyComponentTreeRecursively((ComponentAst)this.withParamComponent, c -> {
            if (c == this.complexParamValue) {
                return expected;
            }
            return c;
        });
        ComponentAst secondCopy = MuleArtifactAstCopyUtils.copyComponentTreeRecursively((ComponentAst)firstCopy, c -> {
            if (c == this.complexParamValue) {
                return new BaseComponentAstDecorator(this.complexParamValue){};
            }
            return c;
        });
        MatcherAssert.assertThat((Object)firstCopy, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)secondCopy)));
    }

    @Test(expected=UnsupportedOperationException.class)
    @Issue(value="W-11208606")
    public void artifactCopyTopLevelElementsImmutable() {
        ArtifactAst copy = MuleArtifactAstCopyUtils.copyRecursively((ArtifactAst)this.artifact, UnaryOperator.identity(), () -> Collections.singletonList(this.randomComponent), c -> false);
        copy.topLevelComponents().clear();
    }

    @Test(expected=UnsupportedOperationException.class)
    @Issue(value="W-11208606")
    public void componentCopyDirectChildrenImmutable() {
        ComponentAst copy = MuleArtifactAstCopyUtils.copyComponentTreeRecursively((ComponentAst)this.topLevelComponent, comp -> comp == this.processor ? (ComponentAst)Mockito.mock(ComponentAst.class) : comp);
        copy.directChildren().clear();
    }
}

