/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.test.internal.builder;

import com.google.common.base.Objects;
import java.util.Collections;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentGenerationInformation;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.builder.ComponentAstBuilder;
import org.mule.runtime.ast.internal.DefaultComponentMetadataAst;
import org.mule.runtime.ast.internal.DefaultComponentParameterAst;
import org.mule.runtime.ast.internal.builder.DefaultComponentAstBuilder;
import org.mule.runtime.ast.internal.builder.PropertiesResolver;
import org.mule.runtime.ast.internal.model.DefaultExtensionModelHelper;
import org.mule.runtime.ast.test.api.util.TestUtils;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;

public class PropertiesResolverTestCase {
    private static final String PARAM_NAME = "param";
    private static final String PARAM_FIXED_VALUE = "fixed";
    private static final String PARAM_PLACEHOLDER_VALUE = "value!";
    private static final String PARAM_PLACEHOLDER = "${key}";
    private static final UnaryOperator<String> SIMPLE_PROPERTY_MAPPING = key -> {
        if (Objects.equal((Object)PARAM_PLACEHOLDER, (Object)key)) {
            return PARAM_PLACEHOLDER_VALUE;
        }
        return key;
    };
    private PropertiesResolver propertiesResolver;
    private DefaultExtensionModelHelper extModelHelper;
    private ParameterModel componentParamModel;
    private ParameterGroupModel componentParamGroupModel;
    private ParameterizedModel parameterized;
    private ParameterModel idComponentParamModel;
    private ParameterGroupModel idComponentParamGroupModel;
    private ParameterizedModel idParameterized;

    @Before
    public void before() {
        this.propertiesResolver = new PropertiesResolver();
        this.extModelHelper = (DefaultExtensionModelHelper)Mockito.mock(DefaultExtensionModelHelper.class);
        this.componentParamModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)this.componentParamModel.getName()).thenReturn((Object)PARAM_NAME);
        Mockito.when((Object)this.componentParamModel.getType()).thenReturn((Object)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().build());
        this.componentParamGroupModel = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
        Mockito.when((Object)this.componentParamGroupModel.getName()).thenReturn((Object)"General");
        Mockito.when((Object)this.componentParamGroupModel.getParameterModels()).thenReturn(Collections.singletonList(this.componentParamModel));
        Mockito.when((Object)this.componentParamGroupModel.getParameter(PARAM_NAME)).thenReturn(Optional.of(this.componentParamModel));
        this.parameterized = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        Mockito.when((Object)this.parameterized.getAllParameterModels()).thenReturn(Collections.singletonList(this.componentParamModel));
        Mockito.when((Object)this.parameterized.getParameterGroupModels()).thenReturn(Collections.singletonList(this.componentParamGroupModel));
        this.idComponentParamModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)this.idComponentParamModel.getName()).thenReturn((Object)"theId");
        Mockito.when((Object)this.idComponentParamModel.isComponentId()).thenReturn((Object)true);
        Mockito.when((Object)this.idComponentParamModel.isRequired()).thenReturn((Object)true);
        Mockito.when((Object)this.idComponentParamModel.getType()).thenReturn((Object)((MetadataType)Mockito.mock(MetadataType.class)));
        this.idComponentParamGroupModel = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
        Mockito.when((Object)this.idComponentParamGroupModel.getName()).thenReturn((Object)"General");
        Mockito.when((Object)this.idComponentParamGroupModel.getParameterModels()).thenReturn(Collections.singletonList(this.idComponentParamModel));
        Mockito.when((Object)this.idComponentParamGroupModel.getParameter(PARAM_NAME)).thenReturn(Optional.of(this.idComponentParamModel));
        this.idParameterized = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        Mockito.when((Object)this.idParameterized.getAllParameterModels()).thenReturn(Collections.singletonList(this.idComponentParamModel));
        Mockito.when((Object)this.idParameterized.getParameterGroupModels()).thenReturn(Collections.singletonList(this.idComponentParamGroupModel));
    }

    @Test
    public void nullValueParam() {
        this.propertiesResolver.setMappingFunction(SIMPLE_PROPERTY_MAPPING);
        MatcherAssert.assertThat((Object)new DefaultComponentParameterAst((String)null, (ParameterModel)Mockito.mock(ParameterModel.class), TestUtils.createMockParameterGroup(new ParameterModel[0]), (ComponentGenerationInformation)Mockito.mock(ComponentGenerationInformation.class), this.propertiesResolver).getRawValue(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void fixedParam() {
        this.propertiesResolver.setMappingFunction(SIMPLE_PROPERTY_MAPPING);
        MatcherAssert.assertThat((Object)new DefaultComponentParameterAst(PARAM_FIXED_VALUE, (ParameterModel)Mockito.mock(ParameterModel.class), TestUtils.createMockParameterGroup(new ParameterModel[0]), (ComponentGenerationInformation)Mockito.mock(ComponentGenerationInformation.class), this.propertiesResolver).getRawValue(), (Matcher)Matchers.is((Object)PARAM_FIXED_VALUE));
    }

    @Test
    public void fixedComplexValueParam() {
        this.propertiesResolver.setMappingFunction(SIMPLE_PROPERTY_MAPPING);
        DefaultComponentAstBuilder complexParamValue = this.complexParamValueStub();
        complexParamValue.withRawParameter(PARAM_NAME, PARAM_FIXED_VALUE);
        Either mappedComplexParam = new DefaultComponentParameterAst((ComponentAstBuilder)complexParamValue, (ParameterModel)Mockito.mock(ParameterModel.class), TestUtils.createMockParameterGroup(new ParameterModel[0]), (ComponentMetadataAst)Mockito.mock(ComponentMetadataAst.class), (ComponentGenerationInformation)Mockito.mock(ComponentGenerationInformation.class), this.propertiesResolver).getValue();
        MatcherAssert.assertThat((Object)((String)mappedComplexParam.reduce(UnaryOperator.identity(), complexParam -> ((ComponentAst)complexParam).getParameter("General", PARAM_NAME).getRawValue())), (Matcher)Matchers.is((Object)PARAM_FIXED_VALUE));
    }

    @Test
    public void propertyParam() {
        this.propertiesResolver.setMappingFunction(SIMPLE_PROPERTY_MAPPING);
        MatcherAssert.assertThat((Object)new DefaultComponentParameterAst(PARAM_PLACEHOLDER, (ParameterModel)Mockito.mock(ParameterModel.class), TestUtils.createMockParameterGroup(new ParameterModel[0]), (ComponentGenerationInformation)Mockito.mock(ComponentGenerationInformation.class), this.propertiesResolver).getResolvedRawValue(), (Matcher)Matchers.is((Object)PARAM_PLACEHOLDER_VALUE));
    }

    @Test
    public void propertyComplexValueParam() {
        this.propertiesResolver.setMappingFunction(SIMPLE_PROPERTY_MAPPING);
        DefaultComponentAstBuilder complexParamValue = this.complexParamValueStub();
        complexParamValue.withRawParameter(PARAM_NAME, PARAM_PLACEHOLDER);
        Either mappedComplexParam = new DefaultComponentParameterAst((ComponentAstBuilder)complexParamValue, (ParameterModel)Mockito.mock(ParameterModel.class), TestUtils.createMockParameterGroup(new ParameterModel[0]), (ComponentMetadataAst)Mockito.mock(ComponentMetadataAst.class), (ComponentGenerationInformation)Mockito.mock(ComponentGenerationInformation.class), this.propertiesResolver).getValue();
        MatcherAssert.assertThat((Object)((String)mappedComplexParam.reduce(UnaryOperator.identity(), complexParam -> ((ComponentAst)complexParam).getParameter("General", PARAM_NAME).getRawValue())), (Matcher)Matchers.is((Object)PARAM_PLACEHOLDER));
        MatcherAssert.assertThat((Object)((String)mappedComplexParam.reduce(UnaryOperator.identity(), complexParam -> ((ComponentAst)complexParam).getParameter("General", PARAM_NAME).getResolvedRawValue())), (Matcher)Matchers.is((Object)PARAM_PLACEHOLDER_VALUE));
    }

    @Test
    public void propertyParamNoMapping() {
        MatcherAssert.assertThat((Object)new DefaultComponentParameterAst(PARAM_PLACEHOLDER, (ParameterModel)Mockito.mock(ParameterModel.class), TestUtils.createMockParameterGroup(new ParameterModel[0]), (ComponentGenerationInformation)Mockito.mock(ComponentGenerationInformation.class), this.propertiesResolver).getRawValue(), (Matcher)Matchers.is((Object)PARAM_PLACEHOLDER));
    }

    @Test
    public void propertyComplexValueParamNoMapping() {
        DefaultComponentAstBuilder complexParamValue = this.complexParamValueStub();
        complexParamValue.withRawParameter(PARAM_NAME, PARAM_PLACEHOLDER);
        Either mappedComplexParam = new DefaultComponentParameterAst((ComponentAstBuilder)complexParamValue, (ParameterModel)Mockito.mock(ParameterModel.class), TestUtils.createMockParameterGroup(new ParameterModel[0]), (ComponentMetadataAst)Mockito.mock(ComponentMetadataAst.class), (ComponentGenerationInformation)Mockito.mock(ComponentGenerationInformation.class), this.propertiesResolver).getValue();
        MatcherAssert.assertThat((Object)((String)mappedComplexParam.reduce(UnaryOperator.identity(), complexParam -> ((ComponentAst)complexParam).getParameter("General", PARAM_NAME).getRawValue())), (Matcher)Matchers.is((Object)PARAM_PLACEHOLDER));
    }

    @Test
    public void componentIdMapped() {
        DefaultComponentAstBuilder idParamValue = new DefaultComponentAstBuilder(this.propertiesResolver, this.extModelHelper, Collections.emptyList(), 0);
        idParamValue.getGenerationInformation().withSyntax((DslElementSyntax)Mockito.mock(DslElementSyntax.class));
        ComponentIdentifier identifier = ComponentIdentifier.builder().namespace("mockns").name("compWithId").build();
        idParamValue.withIdentifier(identifier);
        idParamValue.withMetadata(DefaultComponentMetadataAst.builder().build());
        ComponentAstBuilder builder = idParamValue.withParameterizedModel(this.idParameterized).withRawParameter("theId", PARAM_PLACEHOLDER);
        this.propertiesResolver.setMappingFunction(SIMPLE_PROPERTY_MAPPING);
        ComponentAst comp = builder.build();
        MatcherAssert.assertThat((Object)((String)comp.getComponentId().get()), (Matcher)Matchers.is((Object)PARAM_PLACEHOLDER_VALUE));
    }

    private DefaultComponentAstBuilder complexParamValueStub() {
        ComponentIdentifier identifier = ComponentIdentifier.builder().namespace("mockns").name("comp").build();
        Mockito.when((Object)this.extModelHelper.findComponentType(identifier)).thenReturn((Object)TypedComponentIdentifier.ComponentType.UNKNOWN);
        DefaultComponentAstBuilder complexParamValue = new DefaultComponentAstBuilder(this.propertiesResolver, this.extModelHelper, Collections.emptyList(), 0);
        complexParamValue.withIdentifier(identifier);
        complexParamValue.withMetadata(DefaultComponentMetadataAst.builder().build());
        complexParamValue.withParameterizedModel(this.parameterized);
        complexParamValue.getGenerationInformation().withSyntax((DslElementSyntax)Mockito.mock(DslElementSyntax.class));
        return complexParamValue;
    }
}

