/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.api.validation;

import org.mule.api.annotation.NoImplement;

import java.util.function.Consumer;
import java.util.function.Predicate;

/**
 * Provides a way to create {@link ArtifactAstValidator} instances.
 * 
 * @since 1.1
 */
@NoImplement
public interface ArtifactAstValidatorBuilder {

  /**
   * @param validationEnricher a postprocessor to apply on every discovered {@link ValidationsProvider}.
   * @return this builder
   */
  ArtifactAstValidatorBuilder withValidationEnricher(Consumer<ValidationsProvider> validationEnricher);

  /**
   * @param validationsFilter additional filter to apply on the discovered validations before evaluating them.
   * @return this builder
   */
  ArtifactAstValidatorBuilder withValidationsFilter(Predicate<Validation> validationsFilter);

  /**
   * @param artifactRegionClassLoader the classLoader to use to load any resources referenced by the artifact
   * @return this builder
   */
  ArtifactAstValidatorBuilder withArtifactRegionClassLoader(ClassLoader artifactRegionClassLoader);

  /**
   * Determines whether a validation on a parameter value that has depends on a property is ignored or not.
   * <p>
   * The default behavior is to execute all validations.
   * 
   * @param ignoreParamsWithProperties {@code true} to ignore validations on parameters that have a property dependant value.
   * @since 1.1
   */
  ArtifactAstValidatorBuilder ignoreParamsWithProperties(boolean ignoreParamsWithProperties);

  /**
   * @return a newly created {@link ArtifactAstValidator}.
   */
  ArtifactAstValidator build();
}
