/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.api.error;

import org.mule.api.annotation.NoImplement;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.ast.internal.error.DefaultErrorTypeBuilder;


/**
 * Builder for {@link ErrorType}.
 *
 * @since 1.4
 */
@NoImplement
public interface ErrorTypeBuilder {

  /**
   * @return the {@link ErrorTypeBuilder} implementation. This must be the only mechanism to create an instance of
   *         {@link ErrorType}
   */
  static ErrorTypeBuilder builder() {
    return DefaultErrorTypeBuilder.builder();
  }

  /**
   * Sets the error type identifier. @see {@link ErrorType#getIdentifier()}.
   * <p>
   * The identifier must be unique within the same namespace.
   *
   * @param identifier the string representation
   * @return {@code this} builder
   */
  ErrorTypeBuilder identifier(String identifier);

  /**
   * Sets the error type namespace. @see {@link ErrorType#getNamespace()}
   *
   * @param namespace the error type namespace
   * @return {@code this} builder
   */
  ErrorTypeBuilder namespace(String namespace);

  /**
   * Sets the parent error type. @see {@link ErrorType#getParentErrorType()}
   *
   * @param parentErrorType the parent error type
   * @return {@code this} builder
   */
  ErrorTypeBuilder parentErrorType(ErrorType parentErrorType);

  /**
   * Creates a new instance of the configured error type.
   *
   * @return the error type with the provided configuration.
   */
  ErrorType build();

}
