/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.api.validation;

import org.mule.api.annotation.NoImplement;
import org.mule.runtime.ast.api.ArtifactAst;

/**
 * Implementations provide capabilities for running the validations available for a given {@link ArtifactAst}.
 * <p>
 * Instances may be reused for validating many {@link ArtifactAst}s as long as the classloader definitions for all the
 * {@link ArtifactAst} are the same (as provided to the builder of this instance, {@link ArtifactAstValidatorBuilder}).
 * 
 * @since 1.1
 */
@NoImplement
public interface ArtifactAstValidator {

  /**
   * Runs all validations available from the configured classloader
   * ({@link ArtifactAstValidatorBuilder#withArtifactRegionClassLoader(ClassLoader)}.
   * <p>
   * All validations will be run even if failures are found in some. The result will contain all failures.
   *
   * @param artifact the artifact to validate
   * @return the result of the validation
   */
  ValidationResult validate(ArtifactAst artifact);

}
