/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.model;

import static org.mule.runtime.api.util.classloader.MuleImplementationLoaderUtils.getMuleImplementationsLoader;

import static java.util.Collections.emptyList;
import static java.util.Collections.emptySet;
import static java.util.Optional.empty;

import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.parameter.FieldValueProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.ast.internal.DefaultComponentAst;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;

import java.util.List;
import java.util.Optional;
import java.util.Set;

public final class RawParameterModel implements ParameterModel {

  private final String name;

  public RawParameterModel(String name) {
    this.name = name;
  }

  @Override
  public Optional<DeprecationModel> getDeprecationModel() {
    return empty();
  }

  @Override
  public Optional<DisplayModel> getDisplayModel() {
    return empty();
  }

  @Override
  public boolean hasDynamicType() {
    return false;
  }

  @Override
  public MetadataType getType() {
    final ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault()
        .createTypeLoader(getMuleImplementationsLoader());

    return typeLoader.load(String.class);
  }

  @Override
  public <T extends ModelProperty> Optional<T> getModelProperty(Class<T> propertyType) {
    return empty();
  }

  @Override
  public Set<ModelProperty> getModelProperties() {
    return emptySet();
  }

  @Override
  public String getDescription() {
    return "(owner does not have a set model)";
  }

  @Override
  public String getName() {
    return name;
  }

  @Override
  public boolean isRequired() {
    return false;
  }

  @Override
  public boolean isOverrideFromConfig() {
    return false;
  }

  @Override
  public boolean isComponentId() {
    return false;
  }

  @Override
  public Optional<ValueProviderModel> getValueProviderModel() {
    return empty();
  }

  @Override
  public List<FieldValueProviderModel> getFieldValueProviderModels() {
    return emptyList();
  }

  @Override
  public ParameterRole getRole() {
    return ParameterRole.BEHAVIOUR;
  }

  @Override
  public Optional<LayoutModel> getLayoutModel() {
    return empty();
  }

  @Override
  public ExpressionSupport getExpressionSupport() {
    return ExpressionSupport.NOT_SUPPORTED;
  }

  @Override
  public ParameterDslConfiguration getDslConfiguration() {
    return ParameterDslConfiguration.getDefaultInstance();
  }

  @Override
  public Object getDefaultValue() {
    return null;
  }

  @Override
  public List<StereotypeModel> getAllowedStereotypes() {
    return emptyList();
  }

  @Override
  public Optional<MuleVersion> getMinMuleVersion() {
    return empty();
  }
}
